import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbPolicyV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#action LbPolicyV3#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#description LbPolicyV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#listener_id LbPolicyV3#listener_id}.
     *
     * @stability stable
     */
    readonly listenerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#name LbPolicyV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#position LbPolicyV3#position}.
     *
     * @stability stable
     */
    readonly position?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#project_id LbPolicyV3#project_id}.
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#redirect_listener_id LbPolicyV3#redirect_listener_id}.
     *
     * @stability stable
     */
    readonly redirectListenerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#redirect_pool_id LbPolicyV3#redirect_pool_id}.
     *
     * @stability stable
     */
    readonly redirectPoolId?: string;
    /**
     * rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#rules LbPolicyV3#rules}
     *
     * @stability stable
     */
    readonly rules?: LbPolicyV3Rules[];
}
/**
 * @stability stable
 */
export interface LbPolicyV3Rules {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#compare_type LbPolicyV3#compare_type}.
     *
     * @stability stable
     */
    readonly compareType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#type LbPolicyV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html#value LbPolicyV3#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html opentelekomcloud_lb_policy_v3}.
 *
 * @stability stable
 */
export declare class LbPolicyV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_policy_v3.html opentelekomcloud_lb_policy_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbPolicyV3Config);
    private _action?;
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    set action(value: string);
    /**
     * @stability stable
     */
    get actionInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _listenerId?;
    /**
     * @stability stable
     */
    get listenerId(): string;
    /**
     * @stability stable
     */
    set listenerId(value: string);
    /**
     * @stability stable
     */
    get listenerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _position?;
    /**
     * @stability stable
     */
    get position(): number | undefined;
    /**
     * @stability stable
     */
    set position(value: number | undefined);
    /**
     * @stability stable
     */
    resetPosition(): void;
    /**
     * @stability stable
     */
    get positionInput(): number | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _redirectListenerId?;
    /**
     * @stability stable
     */
    get redirectListenerId(): string | undefined;
    /**
     * @stability stable
     */
    set redirectListenerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetRedirectListenerId(): void;
    /**
     * @stability stable
     */
    get redirectListenerIdInput(): string | undefined;
    private _redirectPoolId?;
    /**
     * @stability stable
     */
    get redirectPoolId(): string | undefined;
    /**
     * @stability stable
     */
    set redirectPoolId(value: string | undefined);
    /**
     * @stability stable
     */
    resetRedirectPoolId(): void;
    /**
     * @stability stable
     */
    get redirectPoolIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _rules?;
    /**
     * @stability stable
     */
    get rules(): LbPolicyV3Rules[] | undefined;
    /**
     * @stability stable
     */
    set rules(value: LbPolicyV3Rules[] | undefined);
    /**
     * @stability stable
     */
    resetRules(): void;
    /**
     * @stability stable
     */
    get rulesInput(): LbPolicyV3Rules[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
