import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbPoolV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#description LbPoolV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#lb_algorithm LbPoolV3#lb_algorithm}.
     *
     * @stability stable
     */
    readonly lbAlgorithm: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#listener_id LbPoolV3#listener_id}.
     *
     * @stability stable
     */
    readonly listenerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#loadbalancer_id LbPoolV3#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#name LbPoolV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#project_id LbPoolV3#project_id}.
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#protocol LbPoolV3#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * session_persistence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#session_persistence LbPoolV3#session_persistence}
     *
     * @stability stable
     */
    readonly sessionPersistence?: LbPoolV3SessionPersistence;
}
/**
 * @stability stable
 */
export interface LbPoolV3SessionPersistence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#cookie_name LbPoolV3#cookie_name}.
     *
     * @stability stable
     */
    readonly cookieName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#persistence_timeout LbPoolV3#persistence_timeout}.
     *
     * @stability stable
     */
    readonly persistenceTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html#type LbPoolV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export declare class LbPoolV3SessionPersistenceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cookieName?;
    /**
     * @stability stable
     */
    get cookieName(): string | undefined;
    /**
     * @stability stable
     */
    set cookieName(value: string | undefined);
    /**
     * @stability stable
     */
    resetCookieName(): void;
    /**
     * @stability stable
     */
    get cookieNameInput(): string | undefined;
    private _persistenceTimeout?;
    /**
     * @stability stable
     */
    get persistenceTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set persistenceTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetPersistenceTimeout(): void;
    /**
     * @stability stable
     */
    get persistenceTimeoutInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html opentelekomcloud_lb_pool_v3}.
 *
 * @stability stable
 */
export declare class LbPoolV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_pool_v3.html opentelekomcloud_lb_pool_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbPoolV3Config);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipVersion(): string;
    private _lbAlgorithm?;
    /**
     * @stability stable
     */
    get lbAlgorithm(): string;
    /**
     * @stability stable
     */
    set lbAlgorithm(value: string);
    /**
     * @stability stable
     */
    get lbAlgorithmInput(): string | undefined;
    private _listenerId?;
    /**
     * @stability stable
     */
    get listenerId(): string | undefined;
    /**
     * @stability stable
     */
    set listenerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetListenerId(): void;
    /**
     * @stability stable
     */
    get listenerIdInput(): string | undefined;
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string | undefined;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetLoadbalancerId(): void;
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _sessionPersistence?;
    private __sessionPersistenceOutput;
    /**
     * @stability stable
     */
    get sessionPersistence(): LbPoolV3SessionPersistenceOutputReference;
    /**
     * @stability stable
     */
    putSessionPersistence(value: LbPoolV3SessionPersistence | undefined): void;
    /**
     * @stability stable
     */
    resetSessionPersistence(): void;
    /**
     * @stability stable
     */
    get sessionPersistenceInput(): LbPoolV3SessionPersistence | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
