import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogtankGroupV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_group_v2.html#group_name LogtankGroupV2#group_name}.
     *
     * @stability stable
     */
    readonly groupName: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_group_v2.html opentelekomcloud_logtank_group_v2}.
 *
 * @stability stable
 */
export declare class LogtankGroupV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_group_v2.html opentelekomcloud_logtank_group_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogtankGroupV2Config);
    private _groupName?;
    /**
     * @stability stable
     */
    get groupName(): string;
    /**
     * @stability stable
     */
    set groupName(value: string);
    /**
     * @stability stable
     */
    get groupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ttlInDays(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
