import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogtankTopicV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2.html#group_id LogtankTopicV2#group_id}.
     *
     * @stability stable
     */
    readonly groupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2.html#topic_name LogtankTopicV2#topic_name}.
     *
     * @stability stable
     */
    readonly topicName: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2.html opentelekomcloud_logtank_topic_v2}.
 *
 * @stability stable
 */
export declare class LogtankTopicV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/logtank_topic_v2.html opentelekomcloud_logtank_topic_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogtankTopicV2Config);
    private _groupId?;
    /**
     * @stability stable
     */
    get groupId(): string;
    /**
     * @stability stable
     */
    set groupId(value: string);
    /**
     * @stability stable
     */
    get groupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get indexEnabled(): any;
    private _topicName?;
    /**
     * @stability stable
     */
    get topicName(): string;
    /**
     * @stability stable
     */
    set topicName(value: string);
    /**
     * @stability stable
     */
    get topicNameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
