import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MrsClusterV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#available_zone_id MrsClusterV1#available_zone_id}.
     *
     * @stability stable
     */
    readonly availableZoneId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#billing_type MrsClusterV1#billing_type}.
     *
     * @stability stable
     */
    readonly billingType: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#cluster_admin_secret MrsClusterV1#cluster_admin_secret}.
     *
     * @stability stable
     */
    readonly clusterAdminSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#cluster_name MrsClusterV1#cluster_name}.
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#cluster_type MrsClusterV1#cluster_type}.
     *
     * @stability stable
     */
    readonly clusterType?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#cluster_version MrsClusterV1#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#core_data_volume_count MrsClusterV1#core_data_volume_count}.
     *
     * @stability stable
     */
    readonly coreDataVolumeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#core_data_volume_size MrsClusterV1#core_data_volume_size}.
     *
     * @stability stable
     */
    readonly coreDataVolumeSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#core_data_volume_type MrsClusterV1#core_data_volume_type}.
     *
     * @stability stable
     */
    readonly coreDataVolumeType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#core_node_num MrsClusterV1#core_node_num}.
     *
     * @stability stable
     */
    readonly coreNodeNum: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#core_node_size MrsClusterV1#core_node_size}.
     *
     * @stability stable
     */
    readonly coreNodeSize: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#log_collection MrsClusterV1#log_collection}.
     *
     * @stability stable
     */
    readonly logCollection?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#master_data_volume_count MrsClusterV1#master_data_volume_count}.
     *
     * @stability stable
     */
    readonly masterDataVolumeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#master_data_volume_size MrsClusterV1#master_data_volume_size}.
     *
     * @stability stable
     */
    readonly masterDataVolumeSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#master_data_volume_type MrsClusterV1#master_data_volume_type}.
     *
     * @stability stable
     */
    readonly masterDataVolumeType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#master_node_num MrsClusterV1#master_node_num}.
     *
     * @stability stable
     */
    readonly masterNodeNum: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#master_node_size MrsClusterV1#master_node_size}.
     *
     * @stability stable
     */
    readonly masterNodeSize: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#node_public_cert_name MrsClusterV1#node_public_cert_name}.
     *
     * @stability stable
     */
    readonly nodePublicCertName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#region MrsClusterV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#safe_mode MrsClusterV1#safe_mode}.
     *
     * @stability stable
     */
    readonly safeMode: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#subnet_id MrsClusterV1#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#tags MrsClusterV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#volume_size MrsClusterV1#volume_size}.
     *
     * @stability stable
     */
    readonly volumeSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#volume_type MrsClusterV1#volume_type}.
     *
     * @stability stable
     */
    readonly volumeType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#vpc_id MrsClusterV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * add_jobs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#add_jobs MrsClusterV1#add_jobs}
     *
     * @stability stable
     */
    readonly addJobs?: MrsClusterV1AddJobs[];
    /**
     * bootstrap_scripts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#bootstrap_scripts MrsClusterV1#bootstrap_scripts}
     *
     * @stability stable
     */
    readonly bootstrapScripts?: MrsClusterV1BootstrapScripts[];
    /**
     * component_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#component_list MrsClusterV1#component_list}
     *
     * @stability stable
     */
    readonly componentList: MrsClusterV1ComponentList[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#timeouts MrsClusterV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MrsClusterV1Timeouts;
}
/**
 * @stability stable
 */
export interface MrsClusterV1AddJobs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#arguments MrsClusterV1#arguments}.
     *
     * @stability stable
     */
    readonly arguments?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#file_action MrsClusterV1#file_action}.
     *
     * @stability stable
     */
    readonly fileAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#hive_script_path MrsClusterV1#hive_script_path}.
     *
     * @stability stable
     */
    readonly hiveScriptPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#hql MrsClusterV1#hql}.
     *
     * @stability stable
     */
    readonly hql?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#input MrsClusterV1#input}.
     *
     * @stability stable
     */
    readonly input?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#jar_path MrsClusterV1#jar_path}.
     *
     * @stability stable
     */
    readonly jarPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#job_log MrsClusterV1#job_log}.
     *
     * @stability stable
     */
    readonly jobLog?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#job_name MrsClusterV1#job_name}.
     *
     * @stability stable
     */
    readonly jobName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#job_type MrsClusterV1#job_type}.
     *
     * @stability stable
     */
    readonly jobType: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#output MrsClusterV1#output}.
     *
     * @stability stable
     */
    readonly output?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#shutdown_cluster MrsClusterV1#shutdown_cluster}.
     *
     * @stability stable
     */
    readonly shutdownCluster?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#submit_job_once_cluster_run MrsClusterV1#submit_job_once_cluster_run}.
     *
     * @stability stable
     */
    readonly submitJobOnceClusterRun: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface MrsClusterV1BootstrapScripts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#active_master MrsClusterV1#active_master}.
     *
     * @stability stable
     */
    readonly activeMaster?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#before_component_start MrsClusterV1#before_component_start}.
     *
     * @stability stable
     */
    readonly beforeComponentStart?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#fail_action MrsClusterV1#fail_action}.
     *
     * @stability stable
     */
    readonly failAction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#name MrsClusterV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#nodes MrsClusterV1#nodes}.
     *
     * @stability stable
     */
    readonly nodes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#parameters MrsClusterV1#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#uri MrsClusterV1#uri}.
     *
     * @stability stable
     */
    readonly uri: string;
}
/**
 * @stability stable
 */
export interface MrsClusterV1ComponentList {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#component_name MrsClusterV1#component_name}.
     *
     * @stability stable
     */
    readonly componentName: string;
}
/**
 * @stability stable
 */
export interface MrsClusterV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#create MrsClusterV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html#delete MrsClusterV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class MrsClusterV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html opentelekomcloud_mrs_cluster_v1}.
 *
 * @stability stable
 */
export declare class MrsClusterV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_cluster_v1.html opentelekomcloud_mrs_cluster_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MrsClusterV1Config);
    private _availableZoneId?;
    /**
     * @stability stable
     */
    get availableZoneId(): string;
    /**
     * @stability stable
     */
    set availableZoneId(value: string);
    /**
     * @stability stable
     */
    get availableZoneIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get availableZoneName(): string;
    private _billingType?;
    /**
     * @stability stable
     */
    get billingType(): number;
    /**
     * @stability stable
     */
    set billingType(value: number);
    /**
     * @stability stable
     */
    get billingTypeInput(): number | undefined;
    /**
     * @stability stable
     */
    get chargingStartTime(): string;
    private _clusterAdminSecret?;
    /**
     * @stability stable
     */
    get clusterAdminSecret(): string | undefined;
    /**
     * @stability stable
     */
    set clusterAdminSecret(value: string | undefined);
    /**
     * @stability stable
     */
    resetClusterAdminSecret(): void;
    /**
     * @stability stable
     */
    get clusterAdminSecretInput(): string | undefined;
    /**
     * @stability stable
     */
    get clusterId(): string;
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get clusterState(): string;
    private _clusterType?;
    /**
     * @stability stable
     */
    get clusterType(): number | undefined;
    /**
     * @stability stable
     */
    set clusterType(value: number | undefined);
    /**
     * @stability stable
     */
    resetClusterType(): void;
    /**
     * @stability stable
     */
    get clusterTypeInput(): number | undefined;
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string | undefined;
    /**
     * @stability stable
     */
    set clusterVersion(value: string | undefined);
    /**
     * @stability stable
     */
    resetClusterVersion(): void;
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    private _coreDataVolumeCount?;
    /**
     * @stability stable
     */
    get coreDataVolumeCount(): number | undefined;
    /**
     * @stability stable
     */
    set coreDataVolumeCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetCoreDataVolumeCount(): void;
    /**
     * @stability stable
     */
    get coreDataVolumeCountInput(): number | undefined;
    private _coreDataVolumeSize?;
    /**
     * @stability stable
     */
    get coreDataVolumeSize(): number | undefined;
    /**
     * @stability stable
     */
    set coreDataVolumeSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetCoreDataVolumeSize(): void;
    /**
     * @stability stable
     */
    get coreDataVolumeSizeInput(): number | undefined;
    private _coreDataVolumeType?;
    /**
     * @stability stable
     */
    get coreDataVolumeType(): string | undefined;
    /**
     * @stability stable
     */
    set coreDataVolumeType(value: string | undefined);
    /**
     * @stability stable
     */
    resetCoreDataVolumeType(): void;
    /**
     * @stability stable
     */
    get coreDataVolumeTypeInput(): string | undefined;
    private _coreNodeNum?;
    /**
     * @stability stable
     */
    get coreNodeNum(): number;
    /**
     * @stability stable
     */
    set coreNodeNum(value: number);
    /**
     * @stability stable
     */
    get coreNodeNumInput(): number | undefined;
    /**
     * @stability stable
     */
    get coreNodeProductId(): string;
    private _coreNodeSize?;
    /**
     * @stability stable
     */
    get coreNodeSize(): string;
    /**
     * @stability stable
     */
    set coreNodeSize(value: string);
    /**
     * @stability stable
     */
    get coreNodeSizeInput(): string | undefined;
    /**
     * @stability stable
     */
    get coreNodeSpecId(): string;
    /**
     * @stability stable
     */
    get createAt(): string;
    /**
     * @stability stable
     */
    get deploymentId(): string;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    get errorInfo(): string;
    /**
     * @stability stable
     */
    get externalAlternateIp(): string;
    /**
     * @stability stable
     */
    get externalIp(): string;
    /**
     * @stability stable
     */
    get fee(): string;
    /**
     * @stability stable
     */
    get hadoopVersion(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceId(): string;
    /**
     * @stability stable
     */
    get internalIp(): string;
    private _logCollection?;
    /**
     * @stability stable
     */
    get logCollection(): number | undefined;
    /**
     * @stability stable
     */
    set logCollection(value: number | undefined);
    /**
     * @stability stable
     */
    resetLogCollection(): void;
    /**
     * @stability stable
     */
    get logCollectionInput(): number | undefined;
    private _masterDataVolumeCount?;
    /**
     * @stability stable
     */
    get masterDataVolumeCount(): number | undefined;
    /**
     * @stability stable
     */
    set masterDataVolumeCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetMasterDataVolumeCount(): void;
    /**
     * @stability stable
     */
    get masterDataVolumeCountInput(): number | undefined;
    private _masterDataVolumeSize?;
    /**
     * @stability stable
     */
    get masterDataVolumeSize(): number | undefined;
    /**
     * @stability stable
     */
    set masterDataVolumeSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetMasterDataVolumeSize(): void;
    /**
     * @stability stable
     */
    get masterDataVolumeSizeInput(): number | undefined;
    private _masterDataVolumeType?;
    /**
     * @stability stable
     */
    get masterDataVolumeType(): string | undefined;
    /**
     * @stability stable
     */
    set masterDataVolumeType(value: string | undefined);
    /**
     * @stability stable
     */
    resetMasterDataVolumeType(): void;
    /**
     * @stability stable
     */
    get masterDataVolumeTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get masterNodeIp(): string;
    private _masterNodeNum?;
    /**
     * @stability stable
     */
    get masterNodeNum(): number;
    /**
     * @stability stable
     */
    set masterNodeNum(value: number);
    /**
     * @stability stable
     */
    get masterNodeNumInput(): number | undefined;
    /**
     * @stability stable
     */
    get masterNodeProductId(): string;
    private _masterNodeSize?;
    /**
     * @stability stable
     */
    get masterNodeSize(): string;
    /**
     * @stability stable
     */
    set masterNodeSize(value: string);
    /**
     * @stability stable
     */
    get masterNodeSizeInput(): string | undefined;
    /**
     * @stability stable
     */
    get masterNodeSpecId(): string;
    private _nodePublicCertName?;
    /**
     * @stability stable
     */
    get nodePublicCertName(): string;
    /**
     * @stability stable
     */
    set nodePublicCertName(value: string);
    /**
     * @stability stable
     */
    get nodePublicCertNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get orderId(): string;
    /**
     * @stability stable
     */
    get privateIpFirst(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get remark(): string;
    private _safeMode?;
    /**
     * @stability stable
     */
    get safeMode(): number;
    /**
     * @stability stable
     */
    set safeMode(value: number);
    /**
     * @stability stable
     */
    get safeModeInput(): number | undefined;
    /**
     * @stability stable
     */
    get securityGroupsId(): string;
    /**
     * @stability stable
     */
    get slaveSecurityGroupsId(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get updateAt(): string;
    /**
     * @stability stable
     */
    get vnc(): string;
    private _volumeSize?;
    /**
     * @stability stable
     */
    get volumeSize(): number | undefined;
    /**
     * @stability stable
     */
    set volumeSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetVolumeSize(): void;
    /**
     * @stability stable
     */
    get volumeSizeInput(): number | undefined;
    private _volumeType?;
    /**
     * @stability stable
     */
    get volumeType(): string | undefined;
    /**
     * @stability stable
     */
    set volumeType(value: string | undefined);
    /**
     * @stability stable
     */
    resetVolumeType(): void;
    /**
     * @stability stable
     */
    get volumeTypeInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _addJobs?;
    /**
     * @stability stable
     */
    get addJobs(): MrsClusterV1AddJobs[] | undefined;
    /**
     * @stability stable
     */
    set addJobs(value: MrsClusterV1AddJobs[] | undefined);
    /**
     * @stability stable
     */
    resetAddJobs(): void;
    /**
     * @stability stable
     */
    get addJobsInput(): MrsClusterV1AddJobs[] | undefined;
    private _bootstrapScripts?;
    /**
     * @stability stable
     */
    get bootstrapScripts(): MrsClusterV1BootstrapScripts[] | undefined;
    /**
     * @stability stable
     */
    set bootstrapScripts(value: MrsClusterV1BootstrapScripts[] | undefined);
    /**
     * @stability stable
     */
    resetBootstrapScripts(): void;
    /**
     * @stability stable
     */
    get bootstrapScriptsInput(): MrsClusterV1BootstrapScripts[] | undefined;
    private _componentList?;
    /**
     * @stability stable
     */
    get componentList(): MrsClusterV1ComponentList[];
    /**
     * @stability stable
     */
    set componentList(value: MrsClusterV1ComponentList[]);
    /**
     * @stability stable
     */
    get componentListInput(): MrsClusterV1ComponentList[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): MrsClusterV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MrsClusterV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MrsClusterV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
