import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MrsJobV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#arguments MrsJobV1#arguments}.
     *
     * @stability stable
     */
    readonly arguments?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#cluster_id MrsJobV1#cluster_id}.
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#hive_script_path MrsJobV1#hive_script_path}.
     *
     * @stability stable
     */
    readonly hiveScriptPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#input MrsJobV1#input}.
     *
     * @stability stable
     */
    readonly input?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#is_protected MrsJobV1#is_protected}.
     *
     * @stability stable
     */
    readonly isProtected?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#is_public MrsJobV1#is_public}.
     *
     * @stability stable
     */
    readonly isPublic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#jar_path MrsJobV1#jar_path}.
     *
     * @stability stable
     */
    readonly jarPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#job_log MrsJobV1#job_log}.
     *
     * @stability stable
     */
    readonly jobLog?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#job_name MrsJobV1#job_name}.
     *
     * @stability stable
     */
    readonly jobName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#job_type MrsJobV1#job_type}.
     *
     * @stability stable
     */
    readonly jobType: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#output MrsJobV1#output}.
     *
     * @stability stable
     */
    readonly output?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#region MrsJobV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#timeouts MrsJobV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MrsJobV1Timeouts;
}
/**
 * @stability stable
 */
export interface MrsJobV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#create MrsJobV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#delete MrsJobV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html#update MrsJobV1#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class MrsJobV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html opentelekomcloud_mrs_job_v1}.
 *
 * @stability stable
 */
export declare class MrsJobV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/mrs_job_v1.html opentelekomcloud_mrs_job_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MrsJobV1Config);
    private _arguments?;
    /**
     * @stability stable
     */
    get arguments(): string | undefined;
    /**
     * @stability stable
     */
    set arguments(value: string | undefined);
    /**
     * @stability stable
     */
    resetArguments(): void;
    /**
     * @stability stable
     */
    get argumentsInput(): string | undefined;
    private _clusterId?;
    /**
     * @stability stable
     */
    get clusterId(): string;
    /**
     * @stability stable
     */
    set clusterId(value: string);
    /**
     * @stability stable
     */
    get clusterIdInput(): string | undefined;
    private _hiveScriptPath?;
    /**
     * @stability stable
     */
    get hiveScriptPath(): string | undefined;
    /**
     * @stability stable
     */
    set hiveScriptPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetHiveScriptPath(): void;
    /**
     * @stability stable
     */
    get hiveScriptPathInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _input?;
    /**
     * @stability stable
     */
    get input(): string | undefined;
    /**
     * @stability stable
     */
    set input(value: string | undefined);
    /**
     * @stability stable
     */
    resetInput(): void;
    /**
     * @stability stable
     */
    get inputInput(): string | undefined;
    private _isProtected?;
    /**
     * @stability stable
     */
    get isProtected(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isProtected(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsProtected(): void;
    /**
     * @stability stable
     */
    get isProtectedInput(): boolean | cdktf.IResolvable | undefined;
    private _isPublic?;
    /**
     * @stability stable
     */
    get isPublic(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isPublic(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsPublic(): void;
    /**
     * @stability stable
     */
    get isPublicInput(): boolean | cdktf.IResolvable | undefined;
    private _jarPath?;
    /**
     * @stability stable
     */
    get jarPath(): string;
    /**
     * @stability stable
     */
    set jarPath(value: string);
    /**
     * @stability stable
     */
    get jarPathInput(): string | undefined;
    private _jobLog?;
    /**
     * @stability stable
     */
    get jobLog(): string | undefined;
    /**
     * @stability stable
     */
    set jobLog(value: string | undefined);
    /**
     * @stability stable
     */
    resetJobLog(): void;
    /**
     * @stability stable
     */
    get jobLogInput(): string | undefined;
    private _jobName?;
    /**
     * @stability stable
     */
    get jobName(): string;
    /**
     * @stability stable
     */
    set jobName(value: string);
    /**
     * @stability stable
     */
    get jobNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get jobState(): string;
    private _jobType?;
    /**
     * @stability stable
     */
    get jobType(): number;
    /**
     * @stability stable
     */
    set jobType(value: number);
    /**
     * @stability stable
     */
    get jobTypeInput(): number | undefined;
    private _output?;
    /**
     * @stability stable
     */
    get output(): string | undefined;
    /**
     * @stability stable
     */
    set output(value: string | undefined);
    /**
     * @stability stable
     */
    resetOutput(): void;
    /**
     * @stability stable
     */
    get outputInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): MrsJobV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MrsJobV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MrsJobV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
