import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NatDnatRuleV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#external_service_port NatDnatRuleV2#external_service_port}.
     *
     * @stability stable
     */
    readonly externalServicePort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#floating_ip_id NatDnatRuleV2#floating_ip_id}.
     *
     * @stability stable
     */
    readonly floatingIpId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#internal_service_port NatDnatRuleV2#internal_service_port}.
     *
     * @stability stable
     */
    readonly internalServicePort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#nat_gateway_id NatDnatRuleV2#nat_gateway_id}.
     *
     * @stability stable
     */
    readonly natGatewayId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#port_id NatDnatRuleV2#port_id}.
     *
     * @stability stable
     */
    readonly portId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#private_ip NatDnatRuleV2#private_ip}.
     *
     * @stability stable
     */
    readonly privateIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#protocol NatDnatRuleV2#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#timeouts NatDnatRuleV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NatDnatRuleV2Timeouts;
}
/**
 * @stability stable
 */
export interface NatDnatRuleV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#create NatDnatRuleV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html#delete NatDnatRuleV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class NatDnatRuleV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html opentelekomcloud_nat_dnat_rule_v2}.
 *
 * @stability stable
 */
export declare class NatDnatRuleV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_dnat_rule_v2.html opentelekomcloud_nat_dnat_rule_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NatDnatRuleV2Config);
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _externalServicePort?;
    /**
     * @stability stable
     */
    get externalServicePort(): number;
    /**
     * @stability stable
     */
    set externalServicePort(value: number);
    /**
     * @stability stable
     */
    get externalServicePortInput(): number | undefined;
    /**
     * @stability stable
     */
    get floatingIpAddress(): string;
    private _floatingIpId?;
    /**
     * @stability stable
     */
    get floatingIpId(): string;
    /**
     * @stability stable
     */
    set floatingIpId(value: string);
    /**
     * @stability stable
     */
    get floatingIpIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _internalServicePort?;
    /**
     * @stability stable
     */
    get internalServicePort(): number;
    /**
     * @stability stable
     */
    set internalServicePort(value: number);
    /**
     * @stability stable
     */
    get internalServicePortInput(): number | undefined;
    private _natGatewayId?;
    /**
     * @stability stable
     */
    get natGatewayId(): string;
    /**
     * @stability stable
     */
    set natGatewayId(value: string);
    /**
     * @stability stable
     */
    get natGatewayIdInput(): string | undefined;
    private _portId?;
    /**
     * @stability stable
     */
    get portId(): string | undefined;
    /**
     * @stability stable
     */
    set portId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortId(): void;
    /**
     * @stability stable
     */
    get portIdInput(): string | undefined;
    private _privateIp?;
    /**
     * @stability stable
     */
    get privateIp(): string | undefined;
    /**
     * @stability stable
     */
    set privateIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateIp(): void;
    /**
     * @stability stable
     */
    get privateIpInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): NatDnatRuleV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NatDnatRuleV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NatDnatRuleV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
