import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NatSnatRuleV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#cidr NatSnatRuleV2#cidr}.
     *
     * @stability stable
     */
    readonly cidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#floating_ip_id NatSnatRuleV2#floating_ip_id}.
     *
     * @stability stable
     */
    readonly floatingIpId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#nat_gateway_id NatSnatRuleV2#nat_gateway_id}.
     *
     * @stability stable
     */
    readonly natGatewayId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#network_id NatSnatRuleV2#network_id}.
     *
     * @stability stable
     */
    readonly networkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#region NatSnatRuleV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#source_type NatSnatRuleV2#source_type}.
     *
     * @stability stable
     */
    readonly sourceType?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#timeouts NatSnatRuleV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NatSnatRuleV2Timeouts;
}
/**
 * @stability stable
 */
export interface NatSnatRuleV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#create NatSnatRuleV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html#delete NatSnatRuleV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class NatSnatRuleV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html opentelekomcloud_nat_snat_rule_v2}.
 *
 * @stability stable
 */
export declare class NatSnatRuleV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/nat_snat_rule_v2.html opentelekomcloud_nat_snat_rule_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NatSnatRuleV2Config);
    private _cidr?;
    /**
     * @stability stable
     */
    get cidr(): string | undefined;
    /**
     * @stability stable
     */
    set cidr(value: string | undefined);
    /**
     * @stability stable
     */
    resetCidr(): void;
    /**
     * @stability stable
     */
    get cidrInput(): string | undefined;
    private _floatingIpId?;
    /**
     * @stability stable
     */
    get floatingIpId(): string;
    /**
     * @stability stable
     */
    set floatingIpId(value: string);
    /**
     * @stability stable
     */
    get floatingIpIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _natGatewayId?;
    /**
     * @stability stable
     */
    get natGatewayId(): string;
    /**
     * @stability stable
     */
    set natGatewayId(value: string);
    /**
     * @stability stable
     */
    get natGatewayIdInput(): string | undefined;
    private _networkId?;
    /**
     * @stability stable
     */
    get networkId(): string | undefined;
    /**
     * @stability stable
     */
    set networkId(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetworkId(): void;
    /**
     * @stability stable
     */
    get networkIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _sourceType?;
    /**
     * @stability stable
     */
    get sourceType(): number | undefined;
    /**
     * @stability stable
     */
    set sourceType(value: number | undefined);
    /**
     * @stability stable
     */
    resetSourceType(): void;
    /**
     * @stability stable
     */
    get sourceTypeInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): NatSnatRuleV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NatSnatRuleV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NatSnatRuleV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
