import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkingFloatingipAssociateV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2.html#floating_ip NetworkingFloatingipAssociateV2#floating_ip}.
     *
     * @stability stable
     */
    readonly floatingIp: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2.html#port_id NetworkingFloatingipAssociateV2#port_id}.
     *
     * @stability stable
     */
    readonly portId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2.html#region NetworkingFloatingipAssociateV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2.html opentelekomcloud_networking_floatingip_associate_v2}.
 *
 * @stability stable
 */
export declare class NetworkingFloatingipAssociateV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_floatingip_associate_v2.html opentelekomcloud_networking_floatingip_associate_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkingFloatingipAssociateV2Config);
    private _floatingIp?;
    /**
     * @stability stable
     */
    get floatingIp(): string;
    /**
     * @stability stable
     */
    set floatingIp(value: string);
    /**
     * @stability stable
     */
    get floatingIpInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _portId?;
    /**
     * @stability stable
     */
    get portId(): string;
    /**
     * @stability stable
     */
    set portId(value: string);
    /**
     * @stability stable
     */
    get portIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
