import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkingPortV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#admin_state_up NetworkingPortV2#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#device_id NetworkingPortV2#device_id}.
     *
     * @stability stable
     */
    readonly deviceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#device_owner NetworkingPortV2#device_owner}.
     *
     * @stability stable
     */
    readonly deviceOwner?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#mac_address NetworkingPortV2#mac_address}.
     *
     * @stability stable
     */
    readonly macAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#name NetworkingPortV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#network_id NetworkingPortV2#network_id}.
     *
     * @stability stable
     */
    readonly networkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#no_security_groups NetworkingPortV2#no_security_groups}.
     *
     * @stability stable
     */
    readonly noSecurityGroups?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#port_security_enabled NetworkingPortV2#port_security_enabled}.
     *
     * @stability stable
     */
    readonly portSecurityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#region NetworkingPortV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#security_group_ids NetworkingPortV2#security_group_ids}.
     *
     * @stability stable
     */
    readonly securityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#tenant_id NetworkingPortV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#value_specs NetworkingPortV2#value_specs}.
     *
     * @stability stable
     */
    readonly valueSpecs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * allowed_address_pairs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#allowed_address_pairs NetworkingPortV2#allowed_address_pairs}
     *
     * @stability stable
     */
    readonly allowedAddressPairs?: NetworkingPortV2AllowedAddressPairs[];
    /**
     * fixed_ip block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#fixed_ip NetworkingPortV2#fixed_ip}
     *
     * @stability stable
     */
    readonly fixedIp?: NetworkingPortV2FixedIp[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#timeouts NetworkingPortV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkingPortV2Timeouts;
}
/**
 * @stability stable
 */
export interface NetworkingPortV2AllowedAddressPairs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#ip_address NetworkingPortV2#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#mac_address NetworkingPortV2#mac_address}.
     *
     * @stability stable
     */
    readonly macAddress?: string;
}
/**
 * @stability stable
 */
export interface NetworkingPortV2FixedIp {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#ip_address NetworkingPortV2#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#subnet_id NetworkingPortV2#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
/**
 * @stability stable
 */
export interface NetworkingPortV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#create NetworkingPortV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html#delete NetworkingPortV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class NetworkingPortV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html opentelekomcloud_networking_port_v2}.
 *
 * @stability stable
 */
export declare class NetworkingPortV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_port_v2.html opentelekomcloud_networking_port_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkingPortV2Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get allFixedIps(): string[];
    private _deviceId?;
    /**
     * @stability stable
     */
    get deviceId(): string | undefined;
    /**
     * @stability stable
     */
    set deviceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDeviceId(): void;
    /**
     * @stability stable
     */
    get deviceIdInput(): string | undefined;
    private _deviceOwner?;
    /**
     * @stability stable
     */
    get deviceOwner(): string | undefined;
    /**
     * @stability stable
     */
    set deviceOwner(value: string | undefined);
    /**
     * @stability stable
     */
    resetDeviceOwner(): void;
    /**
     * @stability stable
     */
    get deviceOwnerInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _macAddress?;
    /**
     * @stability stable
     */
    get macAddress(): string | undefined;
    /**
     * @stability stable
     */
    set macAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetMacAddress(): void;
    /**
     * @stability stable
     */
    get macAddressInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkId?;
    /**
     * @stability stable
     */
    get networkId(): string;
    /**
     * @stability stable
     */
    set networkId(value: string);
    /**
     * @stability stable
     */
    get networkIdInput(): string | undefined;
    private _noSecurityGroups?;
    /**
     * @stability stable
     */
    get noSecurityGroups(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set noSecurityGroups(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNoSecurityGroups(): void;
    /**
     * @stability stable
     */
    get noSecurityGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _portSecurityEnabled?;
    /**
     * @stability stable
     */
    get portSecurityEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set portSecurityEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPortSecurityEnabled(): void;
    /**
     * @stability stable
     */
    get portSecurityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _securityGroupIds?;
    /**
     * @stability stable
     */
    get securityGroupIds(): string[] | undefined;
    /**
     * @stability stable
     */
    set securityGroupIds(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSecurityGroupIds(): void;
    /**
     * @stability stable
     */
    get securityGroupIdsInput(): string[] | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    /**
     * @stability stable
     */
    get valueSpecs(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set valueSpecs(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValueSpecs(): void;
    /**
     * @stability stable
     */
    get valueSpecsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _allowedAddressPairs?;
    /**
     * @stability stable
     */
    get allowedAddressPairs(): NetworkingPortV2AllowedAddressPairs[] | undefined;
    /**
     * @stability stable
     */
    set allowedAddressPairs(value: NetworkingPortV2AllowedAddressPairs[] | undefined);
    /**
     * @stability stable
     */
    resetAllowedAddressPairs(): void;
    /**
     * @stability stable
     */
    get allowedAddressPairsInput(): NetworkingPortV2AllowedAddressPairs[] | undefined;
    private _fixedIp?;
    /**
     * @stability stable
     */
    get fixedIp(): NetworkingPortV2FixedIp[] | undefined;
    /**
     * @stability stable
     */
    set fixedIp(value: NetworkingPortV2FixedIp[] | undefined);
    /**
     * @stability stable
     */
    resetFixedIp(): void;
    /**
     * @stability stable
     */
    get fixedIpInput(): NetworkingPortV2FixedIp[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): NetworkingPortV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkingPortV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkingPortV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
