import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkingRouterInterfaceV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html#port_id NetworkingRouterInterfaceV2#port_id}.
     *
     * @stability stable
     */
    readonly portId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html#region NetworkingRouterInterfaceV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html#router_id NetworkingRouterInterfaceV2#router_id}.
     *
     * @stability stable
     */
    readonly routerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html#subnet_id NetworkingRouterInterfaceV2#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html#timeouts NetworkingRouterInterfaceV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkingRouterInterfaceV2Timeouts;
}
/**
 * @stability stable
 */
export interface NetworkingRouterInterfaceV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html#create NetworkingRouterInterfaceV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html#delete NetworkingRouterInterfaceV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class NetworkingRouterInterfaceV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html opentelekomcloud_networking_router_interface_v2}.
 *
 * @stability stable
 */
export declare class NetworkingRouterInterfaceV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_interface_v2.html opentelekomcloud_networking_router_interface_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkingRouterInterfaceV2Config);
    /**
     * @stability stable
     */
    get id(): string;
    private _portId?;
    /**
     * @stability stable
     */
    get portId(): string | undefined;
    /**
     * @stability stable
     */
    set portId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortId(): void;
    /**
     * @stability stable
     */
    get portIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _routerId?;
    /**
     * @stability stable
     */
    get routerId(): string;
    /**
     * @stability stable
     */
    set routerId(value: string);
    /**
     * @stability stable
     */
    get routerIdInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string | undefined;
    /**
     * @stability stable
     */
    set subnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): NetworkingRouterInterfaceV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkingRouterInterfaceV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkingRouterInterfaceV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
