import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkingRouterRouteV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2.html#destination_cidr NetworkingRouterRouteV2#destination_cidr}.
     *
     * @stability stable
     */
    readonly destinationCidr: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2.html#next_hop NetworkingRouterRouteV2#next_hop}.
     *
     * @stability stable
     */
    readonly nextHop: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2.html#region NetworkingRouterRouteV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2.html#router_id NetworkingRouterRouteV2#router_id}.
     *
     * @stability stable
     */
    readonly routerId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2.html opentelekomcloud_networking_router_route_v2}.
 *
 * @stability stable
 */
export declare class NetworkingRouterRouteV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_router_route_v2.html opentelekomcloud_networking_router_route_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkingRouterRouteV2Config);
    private _destinationCidr?;
    /**
     * @stability stable
     */
    get destinationCidr(): string;
    /**
     * @stability stable
     */
    set destinationCidr(value: string);
    /**
     * @stability stable
     */
    get destinationCidrInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _nextHop?;
    /**
     * @stability stable
     */
    get nextHop(): string;
    /**
     * @stability stable
     */
    set nextHop(value: string);
    /**
     * @stability stable
     */
    get nextHopInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _routerId?;
    /**
     * @stability stable
     */
    get routerId(): string;
    /**
     * @stability stable
     */
    set routerId(value: string);
    /**
     * @stability stable
     */
    get routerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
