import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkingSecgroupRuleV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#description NetworkingSecgroupRuleV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#direction NetworkingSecgroupRuleV2#direction}.
     *
     * @stability stable
     */
    readonly direction: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#ethertype NetworkingSecgroupRuleV2#ethertype}.
     *
     * @stability stable
     */
    readonly ethertype: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#port_range_max NetworkingSecgroupRuleV2#port_range_max}.
     *
     * @stability stable
     */
    readonly portRangeMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#port_range_min NetworkingSecgroupRuleV2#port_range_min}.
     *
     * @stability stable
     */
    readonly portRangeMin?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#protocol NetworkingSecgroupRuleV2#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#region NetworkingSecgroupRuleV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#remote_group_id NetworkingSecgroupRuleV2#remote_group_id}.
     *
     * @stability stable
     */
    readonly remoteGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#remote_ip_prefix NetworkingSecgroupRuleV2#remote_ip_prefix}.
     *
     * @stability stable
     */
    readonly remoteIpPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#security_group_id NetworkingSecgroupRuleV2#security_group_id}.
     *
     * @stability stable
     */
    readonly securityGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#tenant_id NetworkingSecgroupRuleV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#timeouts NetworkingSecgroupRuleV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkingSecgroupRuleV2Timeouts;
}
/**
 * @stability stable
 */
export interface NetworkingSecgroupRuleV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html#delete NetworkingSecgroupRuleV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class NetworkingSecgroupRuleV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html opentelekomcloud_networking_secgroup_rule_v2}.
 *
 * @stability stable
 */
export declare class NetworkingSecgroupRuleV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_secgroup_rule_v2.html opentelekomcloud_networking_secgroup_rule_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkingSecgroupRuleV2Config);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _direction?;
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    set direction(value: string);
    /**
     * @stability stable
     */
    get directionInput(): string | undefined;
    private _ethertype?;
    /**
     * @stability stable
     */
    get ethertype(): string;
    /**
     * @stability stable
     */
    set ethertype(value: string);
    /**
     * @stability stable
     */
    get ethertypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _portRangeMax?;
    /**
     * @stability stable
     */
    get portRangeMax(): number | undefined;
    /**
     * @stability stable
     */
    set portRangeMax(value: number | undefined);
    /**
     * @stability stable
     */
    resetPortRangeMax(): void;
    /**
     * @stability stable
     */
    get portRangeMaxInput(): number | undefined;
    private _portRangeMin?;
    /**
     * @stability stable
     */
    get portRangeMin(): number | undefined;
    /**
     * @stability stable
     */
    set portRangeMin(value: number | undefined);
    /**
     * @stability stable
     */
    resetPortRangeMin(): void;
    /**
     * @stability stable
     */
    get portRangeMinInput(): number | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string | undefined;
    /**
     * @stability stable
     */
    set protocol(value: string | undefined);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _remoteGroupId?;
    /**
     * @stability stable
     */
    get remoteGroupId(): string | undefined;
    /**
     * @stability stable
     */
    set remoteGroupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetRemoteGroupId(): void;
    /**
     * @stability stable
     */
    get remoteGroupIdInput(): string | undefined;
    private _remoteIpPrefix?;
    /**
     * @stability stable
     */
    get remoteIpPrefix(): string | undefined;
    /**
     * @stability stable
     */
    set remoteIpPrefix(value: string | undefined);
    /**
     * @stability stable
     */
    resetRemoteIpPrefix(): void;
    /**
     * @stability stable
     */
    get remoteIpPrefixInput(): string | undefined;
    private _securityGroupId?;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    set securityGroupId(value: string);
    /**
     * @stability stable
     */
    get securityGroupIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): NetworkingSecgroupRuleV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkingSecgroupRuleV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkingSecgroupRuleV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
