import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkingSubnetV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#cidr NetworkingSubnetV2#cidr}.
     *
     * @stability stable
     */
    readonly cidr: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#dns_nameservers NetworkingSubnetV2#dns_nameservers}.
     *
     * @stability stable
     */
    readonly dnsNameservers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#enable_dhcp NetworkingSubnetV2#enable_dhcp}.
     *
     * @stability stable
     */
    readonly enableDhcp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#gateway_ip NetworkingSubnetV2#gateway_ip}.
     *
     * @stability stable
     */
    readonly gatewayIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#ip_version NetworkingSubnetV2#ip_version}.
     *
     * @stability stable
     */
    readonly ipVersion?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#name NetworkingSubnetV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#network_id NetworkingSubnetV2#network_id}.
     *
     * @stability stable
     */
    readonly networkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#no_gateway NetworkingSubnetV2#no_gateway}.
     *
     * @stability stable
     */
    readonly noGateway?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#region NetworkingSubnetV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#tenant_id NetworkingSubnetV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#value_specs NetworkingSubnetV2#value_specs}.
     *
     * @stability stable
     */
    readonly valueSpecs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * allocation_pools block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#allocation_pools NetworkingSubnetV2#allocation_pools}
     *
     * @stability stable
     */
    readonly allocationPools?: NetworkingSubnetV2AllocationPools[];
    /**
     * host_routes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#host_routes NetworkingSubnetV2#host_routes}
     *
     * @stability stable
     */
    readonly hostRoutes?: NetworkingSubnetV2HostRoutes[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#timeouts NetworkingSubnetV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkingSubnetV2Timeouts;
}
/**
 * @stability stable
 */
export interface NetworkingSubnetV2AllocationPools {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#end NetworkingSubnetV2#end}.
     *
     * @stability stable
     */
    readonly end: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#start NetworkingSubnetV2#start}.
     *
     * @stability stable
     */
    readonly start: string;
}
/**
 * @stability stable
 */
export interface NetworkingSubnetV2HostRoutes {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#destination_cidr NetworkingSubnetV2#destination_cidr}.
     *
     * @stability stable
     */
    readonly destinationCidr: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#next_hop NetworkingSubnetV2#next_hop}.
     *
     * @stability stable
     */
    readonly nextHop: string;
}
/**
 * @stability stable
 */
export interface NetworkingSubnetV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#create NetworkingSubnetV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html#delete NetworkingSubnetV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class NetworkingSubnetV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html opentelekomcloud_networking_subnet_v2}.
 *
 * @stability stable
 */
export declare class NetworkingSubnetV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_subnet_v2.html opentelekomcloud_networking_subnet_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkingSubnetV2Config);
    private _cidr?;
    /**
     * @stability stable
     */
    get cidr(): string;
    /**
     * @stability stable
     */
    set cidr(value: string);
    /**
     * @stability stable
     */
    get cidrInput(): string | undefined;
    private _dnsNameservers?;
    /**
     * @stability stable
     */
    get dnsNameservers(): string[] | undefined;
    /**
     * @stability stable
     */
    set dnsNameservers(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetDnsNameservers(): void;
    /**
     * @stability stable
     */
    get dnsNameserversInput(): string[] | undefined;
    private _enableDhcp?;
    /**
     * @stability stable
     */
    get enableDhcp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableDhcp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableDhcp(): void;
    /**
     * @stability stable
     */
    get enableDhcpInput(): boolean | cdktf.IResolvable | undefined;
    private _gatewayIp?;
    /**
     * @stability stable
     */
    get gatewayIp(): string | undefined;
    /**
     * @stability stable
     */
    set gatewayIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetGatewayIp(): void;
    /**
     * @stability stable
     */
    get gatewayIpInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipVersion?;
    /**
     * @stability stable
     */
    get ipVersion(): number | undefined;
    /**
     * @stability stable
     */
    set ipVersion(value: number | undefined);
    /**
     * @stability stable
     */
    resetIpVersion(): void;
    /**
     * @stability stable
     */
    get ipVersionInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkId?;
    /**
     * @stability stable
     */
    get networkId(): string;
    /**
     * @stability stable
     */
    set networkId(value: string);
    /**
     * @stability stable
     */
    get networkIdInput(): string | undefined;
    private _noGateway?;
    /**
     * @stability stable
     */
    get noGateway(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set noGateway(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNoGateway(): void;
    /**
     * @stability stable
     */
    get noGatewayInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    /**
     * @stability stable
     */
    get valueSpecs(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set valueSpecs(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValueSpecs(): void;
    /**
     * @stability stable
     */
    get valueSpecsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _allocationPools?;
    /**
     * @stability stable
     */
    get allocationPools(): NetworkingSubnetV2AllocationPools[] | undefined;
    /**
     * @stability stable
     */
    set allocationPools(value: NetworkingSubnetV2AllocationPools[] | undefined);
    /**
     * @stability stable
     */
    resetAllocationPools(): void;
    /**
     * @stability stable
     */
    get allocationPoolsInput(): NetworkingSubnetV2AllocationPools[] | undefined;
    private _hostRoutes?;
    /**
     * @stability stable
     */
    get hostRoutes(): NetworkingSubnetV2HostRoutes[] | undefined;
    /**
     * @stability stable
     */
    set hostRoutes(value: NetworkingSubnetV2HostRoutes[] | undefined);
    /**
     * @stability stable
     */
    resetHostRoutes(): void;
    /**
     * @stability stable
     */
    get hostRoutesInput(): NetworkingSubnetV2HostRoutes[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): NetworkingSubnetV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkingSubnetV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkingSubnetV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
