import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkingVipAssociateV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2.html#port_ids NetworkingVipAssociateV2#port_ids}.
     *
     * @stability stable
     */
    readonly portIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2.html#vip_id NetworkingVipAssociateV2#vip_id}.
     *
     * @stability stable
     */
    readonly vipId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2.html opentelekomcloud_networking_vip_associate_v2}.
 *
 * @stability stable
 */
export declare class NetworkingVipAssociateV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_associate_v2.html opentelekomcloud_networking_vip_associate_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkingVipAssociateV2Config);
    /**
     * @stability stable
     */
    get id(): string;
    private _portIds?;
    /**
     * @stability stable
     */
    get portIds(): string[];
    /**
     * @stability stable
     */
    set portIds(value: string[]);
    /**
     * @stability stable
     */
    get portIdsInput(): string[] | undefined;
    private _vipId?;
    /**
     * @stability stable
     */
    get vipId(): string;
    /**
     * @stability stable
     */
    set vipId(value: string);
    /**
     * @stability stable
     */
    get vipIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get vipIpAddress(): string;
    /**
     * @stability stable
     */
    get vipSubnetId(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
