import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkingVipV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_v2.html#ip_address NetworkingVipV2#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_v2.html#name NetworkingVipV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_v2.html#network_id NetworkingVipV2#network_id}.
     *
     * @stability stable
     */
    readonly networkId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_v2.html#subnet_id NetworkingVipV2#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_v2.html opentelekomcloud_networking_vip_v2}.
 *
 * @stability stable
 */
export declare class NetworkingVipV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/networking_vip_v2.html opentelekomcloud_networking_vip_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkingVipV2Config);
    /**
     * @stability stable
     */
    get deviceOwner(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string | undefined;
    /**
     * @stability stable
     */
    set ipAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkId?;
    /**
     * @stability stable
     */
    get networkId(): string;
    /**
     * @stability stable
     */
    set networkId(value: string);
    /**
     * @stability stable
     */
    get networkIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
