import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ObsBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#acl ObsBucketObject#acl}.
     *
     * @stability stable
     */
    readonly acl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#bucket ObsBucketObject#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#content ObsBucketObject#content}.
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#content_type ObsBucketObject#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#encryption ObsBucketObject#encryption}.
     *
     * @stability stable
     */
    readonly encryption?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#etag ObsBucketObject#etag}.
     *
     * @stability stable
     */
    readonly etag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#key ObsBucketObject#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#kms_key_id ObsBucketObject#kms_key_id}.
     *
     * @stability stable
     */
    readonly kmsKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#source ObsBucketObject#source}.
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html#storage_class ObsBucketObject#storage_class}.
     *
     * @stability stable
     */
    readonly storageClass?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html opentelekomcloud_obs_bucket_object}.
 *
 * @stability stable
 */
export declare class ObsBucketObject extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket_object.html opentelekomcloud_obs_bucket_object} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ObsBucketObjectConfig);
    private _acl?;
    /**
     * @stability stable
     */
    get acl(): string | undefined;
    /**
     * @stability stable
     */
    set acl(value: string | undefined);
    /**
     * @stability stable
     */
    resetAcl(): void;
    /**
     * @stability stable
     */
    get aclInput(): string | undefined;
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string | undefined;
    /**
     * @stability stable
     */
    set content(value: string | undefined);
    /**
     * @stability stable
     */
    resetContent(): void;
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string | undefined;
    /**
     * @stability stable
     */
    set contentType(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _encryption?;
    /**
     * @stability stable
     */
    get encryption(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set encryption(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEncryption(): void;
    /**
     * @stability stable
     */
    get encryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _etag?;
    /**
     * @stability stable
     */
    get etag(): string | undefined;
    /**
     * @stability stable
     */
    set etag(value: string | undefined);
    /**
     * @stability stable
     */
    resetEtag(): void;
    /**
     * @stability stable
     */
    get etagInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _kmsKeyId?;
    /**
     * @stability stable
     */
    get kmsKeyId(): string | undefined;
    /**
     * @stability stable
     */
    set kmsKeyId(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsKeyId(): void;
    /**
     * @stability stable
     */
    get kmsKeyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get size(): number;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string | undefined;
    /**
     * @stability stable
     */
    set source(value: string | undefined);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _storageClass?;
    /**
     * @stability stable
     */
    get storageClass(): string | undefined;
    /**
     * @stability stable
     */
    set storageClass(value: string | undefined);
    /**
     * @stability stable
     */
    resetStorageClass(): void;
    /**
     * @stability stable
     */
    get storageClassInput(): string | undefined;
    /**
     * @stability stable
     */
    get versionId(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
