import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ObsBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#acl ObsBucket#acl}.
     *
     * @stability stable
     */
    readonly acl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#bucket ObsBucket#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#force_destroy ObsBucket#force_destroy}.
     *
     * @stability stable
     */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#region ObsBucket#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#storage_class ObsBucket#storage_class}.
     *
     * @stability stable
     */
    readonly storageClass?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#tags ObsBucket#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#versioning ObsBucket#versioning}.
     *
     * @stability stable
     */
    readonly versioning?: boolean | cdktf.IResolvable;
    /**
     * cors_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#cors_rule ObsBucket#cors_rule}
     *
     * @stability stable
     */
    readonly corsRule?: ObsBucketCorsRule[];
    /**
     * event_notifications block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#event_notifications ObsBucket#event_notifications}
     *
     * @stability stable
     */
    readonly eventNotifications?: ObsBucketEventNotifications[];
    /**
     * lifecycle_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#lifecycle_rule ObsBucket#lifecycle_rule}
     *
     * @stability stable
     */
    readonly lifecycleRule?: ObsBucketLifecycleRule[];
    /**
     * logging block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#logging ObsBucket#logging}
     *
     * @stability stable
     */
    readonly logging?: ObsBucketLogging[];
    /**
     * server_side_encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#server_side_encryption ObsBucket#server_side_encryption}
     *
     * @stability stable
     */
    readonly serverSideEncryption?: ObsBucketServerSideEncryption;
    /**
     * website block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#website ObsBucket#website}
     *
     * @stability stable
     */
    readonly website?: ObsBucketWebsite;
}
/**
 * @stability stable
 */
export interface ObsBucketCorsRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#allowed_headers ObsBucket#allowed_headers}.
     *
     * @stability stable
     */
    readonly allowedHeaders?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#allowed_methods ObsBucket#allowed_methods}.
     *
     * @stability stable
     */
    readonly allowedMethods: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#allowed_origins ObsBucket#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#expose_headers ObsBucket#expose_headers}.
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#max_age_seconds ObsBucket#max_age_seconds}.
     *
     * @stability stable
     */
    readonly maxAgeSeconds?: number;
}
/**
 * @stability stable
 */
export interface ObsBucketEventNotificationsFilterRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#name ObsBucket#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#value ObsBucket#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export interface ObsBucketEventNotifications {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#events ObsBucket#events}.
     *
     * @stability stable
     */
    readonly events: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#id ObsBucket#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#topic ObsBucket#topic}.
     *
     * @stability stable
     */
    readonly topic: string;
    /**
     * filter_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#filter_rule ObsBucket#filter_rule}
     *
     * @stability stable
     */
    readonly filterRule?: ObsBucketEventNotificationsFilterRule[];
}
/**
 * @stability stable
 */
export interface ObsBucketLifecycleRuleExpiration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#days ObsBucket#days}.
     *
     * @stability stable
     */
    readonly days: number;
}
/**
 * @stability stable
 */
export interface ObsBucketLifecycleRuleNoncurrentVersionExpiration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#days ObsBucket#days}.
     *
     * @stability stable
     */
    readonly days: number;
}
/**
 * @stability stable
 */
export interface ObsBucketLifecycleRuleNoncurrentVersionTransition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#days ObsBucket#days}.
     *
     * @stability stable
     */
    readonly days: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#storage_class ObsBucket#storage_class}.
     *
     * @stability stable
     */
    readonly storageClass: string;
}
/**
 * @stability stable
 */
export interface ObsBucketLifecycleRuleTransition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#days ObsBucket#days}.
     *
     * @stability stable
     */
    readonly days: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#storage_class ObsBucket#storage_class}.
     *
     * @stability stable
     */
    readonly storageClass: string;
}
/**
 * @stability stable
 */
export interface ObsBucketLifecycleRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#enabled ObsBucket#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#name ObsBucket#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#prefix ObsBucket#prefix}.
     *
     * @stability stable
     */
    readonly prefix?: string;
    /**
     * expiration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#expiration ObsBucket#expiration}
     *
     * @stability stable
     */
    readonly expiration?: ObsBucketLifecycleRuleExpiration[];
    /**
     * noncurrent_version_expiration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#noncurrent_version_expiration ObsBucket#noncurrent_version_expiration}
     *
     * @stability stable
     */
    readonly noncurrentVersionExpiration?: ObsBucketLifecycleRuleNoncurrentVersionExpiration[];
    /**
     * noncurrent_version_transition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#noncurrent_version_transition ObsBucket#noncurrent_version_transition}
     *
     * @stability stable
     */
    readonly noncurrentVersionTransition?: ObsBucketLifecycleRuleNoncurrentVersionTransition[];
    /**
     * transition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#transition ObsBucket#transition}
     *
     * @stability stable
     */
    readonly transition?: ObsBucketLifecycleRuleTransition[];
}
/**
 * @stability stable
 */
export interface ObsBucketLogging {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#target_bucket ObsBucket#target_bucket}.
     *
     * @stability stable
     */
    readonly targetBucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#target_prefix ObsBucket#target_prefix}.
     *
     * @stability stable
     */
    readonly targetPrefix?: string;
}
/**
 * @stability stable
 */
export interface ObsBucketServerSideEncryption {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#algorithm ObsBucket#algorithm}.
     *
     * @stability stable
     */
    readonly algorithm: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#kms_key_id ObsBucket#kms_key_id}.
     *
     * @stability stable
     */
    readonly kmsKeyId: string;
}
/**
 * @stability stable
 */
export declare class ObsBucketServerSideEncryptionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _algorithm?;
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    set algorithm(value: string);
    /**
     * @stability stable
     */
    get algorithmInput(): string | undefined;
    private _kmsKeyId?;
    /**
     * @stability stable
     */
    get kmsKeyId(): string;
    /**
     * @stability stable
     */
    set kmsKeyId(value: string);
    /**
     * @stability stable
     */
    get kmsKeyIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ObsBucketWebsite {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#error_document ObsBucket#error_document}.
     *
     * @stability stable
     */
    readonly errorDocument?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#index_document ObsBucket#index_document}.
     *
     * @stability stable
     */
    readonly indexDocument?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#redirect_all_requests_to ObsBucket#redirect_all_requests_to}.
     *
     * @stability stable
     */
    readonly redirectAllRequestsTo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html#routing_rules ObsBucket#routing_rules}.
     *
     * @stability stable
     */
    readonly routingRules?: string;
}
/**
 * @stability stable
 */
export declare class ObsBucketWebsiteOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _errorDocument?;
    /**
     * @stability stable
     */
    get errorDocument(): string | undefined;
    /**
     * @stability stable
     */
    set errorDocument(value: string | undefined);
    /**
     * @stability stable
     */
    resetErrorDocument(): void;
    /**
     * @stability stable
     */
    get errorDocumentInput(): string | undefined;
    private _indexDocument?;
    /**
     * @stability stable
     */
    get indexDocument(): string | undefined;
    /**
     * @stability stable
     */
    set indexDocument(value: string | undefined);
    /**
     * @stability stable
     */
    resetIndexDocument(): void;
    /**
     * @stability stable
     */
    get indexDocumentInput(): string | undefined;
    private _redirectAllRequestsTo?;
    /**
     * @stability stable
     */
    get redirectAllRequestsTo(): string | undefined;
    /**
     * @stability stable
     */
    set redirectAllRequestsTo(value: string | undefined);
    /**
     * @stability stable
     */
    resetRedirectAllRequestsTo(): void;
    /**
     * @stability stable
     */
    get redirectAllRequestsToInput(): string | undefined;
    private _routingRules?;
    /**
     * @stability stable
     */
    get routingRules(): string | undefined;
    /**
     * @stability stable
     */
    set routingRules(value: string | undefined);
    /**
     * @stability stable
     */
    resetRoutingRules(): void;
    /**
     * @stability stable
     */
    get routingRulesInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html opentelekomcloud_obs_bucket}.
 *
 * @stability stable
 */
export declare class ObsBucket extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/obs_bucket.html opentelekomcloud_obs_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ObsBucketConfig);
    private _acl?;
    /**
     * @stability stable
     */
    get acl(): string | undefined;
    /**
     * @stability stable
     */
    set acl(value: string | undefined);
    /**
     * @stability stable
     */
    resetAcl(): void;
    /**
     * @stability stable
     */
    get aclInput(): string | undefined;
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get bucketDomainName(): string;
    private _forceDestroy?;
    /**
     * @stability stable
     */
    get forceDestroy(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forceDestroy(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForceDestroy(): void;
    /**
     * @stability stable
     */
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _storageClass?;
    /**
     * @stability stable
     */
    get storageClass(): string | undefined;
    /**
     * @stability stable
     */
    set storageClass(value: string | undefined);
    /**
     * @stability stable
     */
    resetStorageClass(): void;
    /**
     * @stability stable
     */
    get storageClassInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _versioning?;
    /**
     * @stability stable
     */
    get versioning(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set versioning(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetVersioning(): void;
    /**
     * @stability stable
     */
    get versioningInput(): boolean | cdktf.IResolvable | undefined;
    private _corsRule?;
    /**
     * @stability stable
     */
    get corsRule(): ObsBucketCorsRule[] | undefined;
    /**
     * @stability stable
     */
    set corsRule(value: ObsBucketCorsRule[] | undefined);
    /**
     * @stability stable
     */
    resetCorsRule(): void;
    /**
     * @stability stable
     */
    get corsRuleInput(): ObsBucketCorsRule[] | undefined;
    private _eventNotifications?;
    /**
     * @stability stable
     */
    get eventNotifications(): ObsBucketEventNotifications[] | undefined;
    /**
     * @stability stable
     */
    set eventNotifications(value: ObsBucketEventNotifications[] | undefined);
    /**
     * @stability stable
     */
    resetEventNotifications(): void;
    /**
     * @stability stable
     */
    get eventNotificationsInput(): ObsBucketEventNotifications[] | undefined;
    private _lifecycleRule?;
    /**
     * @stability stable
     */
    get lifecycleRule(): ObsBucketLifecycleRule[] | undefined;
    /**
     * @stability stable
     */
    set lifecycleRule(value: ObsBucketLifecycleRule[] | undefined);
    /**
     * @stability stable
     */
    resetLifecycleRule(): void;
    /**
     * @stability stable
     */
    get lifecycleRuleInput(): ObsBucketLifecycleRule[] | undefined;
    private _logging?;
    /**
     * @stability stable
     */
    get logging(): ObsBucketLogging[] | undefined;
    /**
     * @stability stable
     */
    set logging(value: ObsBucketLogging[] | undefined);
    /**
     * @stability stable
     */
    resetLogging(): void;
    /**
     * @stability stable
     */
    get loggingInput(): ObsBucketLogging[] | undefined;
    private _serverSideEncryption?;
    private __serverSideEncryptionOutput;
    /**
     * @stability stable
     */
    get serverSideEncryption(): ObsBucketServerSideEncryptionOutputReference;
    /**
     * @stability stable
     */
    putServerSideEncryption(value: ObsBucketServerSideEncryption | undefined): void;
    /**
     * @stability stable
     */
    resetServerSideEncryption(): void;
    /**
     * @stability stable
     */
    get serverSideEncryptionInput(): ObsBucketServerSideEncryption | undefined;
    private _website?;
    private __websiteOutput;
    /**
     * @stability stable
     */
    get website(): ObsBucketWebsiteOutputReference;
    /**
     * @stability stable
     */
    putWebsite(value: ObsBucketWebsite | undefined): void;
    /**
     * @stability stable
     */
    resetWebsite(): void;
    /**
     * @stability stable
     */
    get websiteInput(): ObsBucketWebsite | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
