import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OpentelekomcloudProviderConfig {
    /**
     * The access key for API operations. You can retrieve this from the 'My Credential' section of the console.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#access_key OpentelekomcloudProvider#access_key}
     *
     * @stability stable
     */
    readonly accessKey?: string;
    /**
     * The name of domain who created the agency (Identity v3).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#agency_domain_name OpentelekomcloudProvider#agency_domain_name}
     *
     * @stability stable
     */
    readonly agencyDomainName?: string;
    /**
     * The name of agency.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#agency_name OpentelekomcloudProvider#agency_name}
     *
     * @stability stable
     */
    readonly agencyName?: string;
    /**
     * The Identity authentication URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#auth_url OpentelekomcloudProvider#auth_url}
     *
     * @stability stable
     */
    readonly authUrl?: string;
    /**
     * A Custom CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#cacert_file OpentelekomcloudProvider#cacert_file}
     *
     * @stability stable
     */
    readonly cacertFile?: string;
    /**
     * A client certificate to authenticate with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#cert OpentelekomcloudProvider#cert}
     *
     * @stability stable
     */
    readonly cert?: string;
    /**
     * An entry in a `clouds.yaml` file to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#cloud OpentelekomcloudProvider#cloud}
     *
     * @stability stable
     */
    readonly cloud?: string;
    /**
     * The name of delegated project (Identity v3).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#delegated_project OpentelekomcloudProvider#delegated_project}
     *
     * @stability stable
     */
    readonly delegatedProject?: string;
    /**
     * The ID of the Domain to scope to (Identity v3).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#domain_id OpentelekomcloudProvider#domain_id}
     *
     * @stability stable
     */
    readonly domainId?: string;
    /**
     * The name of the Domain to scope to (Identity v3).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#domain_name OpentelekomcloudProvider#domain_name}
     *
     * @stability stable
     */
    readonly domainName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#endpoint_type OpentelekomcloudProvider#endpoint_type}.
     *
     * @stability stable
     */
    readonly endpointType?: string;
    /**
     * Trust self-signed certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#insecure OpentelekomcloudProvider#insecure}
     *
     * @stability stable
     */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
     * A client private key to authenticate with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#key OpentelekomcloudProvider#key}
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * How many times HTTP connection should be retried until giving up.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#max_retries OpentelekomcloudProvider#max_retries}
     *
     * @stability stable
     */
    readonly maxRetries?: number;
    /**
     * One-time MFA passcode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#passcode OpentelekomcloudProvider#passcode}
     *
     * @stability stable
     */
    readonly passcode?: string;
    /**
     * Password to login with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#password OpentelekomcloudProvider#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * The OpenTelekomCloud region to connect to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#region OpentelekomcloudProvider#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The secret key for API operations. You can retrieve this from the 'My Credential' section of the console.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#secret_key OpentelekomcloudProvider#secret_key}
     *
     * @stability stable
     */
    readonly secretKey?: string;
    /**
     * Security token to use for OBS federated authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#security_token OpentelekomcloudProvider#security_token}
     *
     * @stability stable
     */
    readonly securityToken?: string;
    /**
     * Use Swift's authentication system instead of Keystone. Only used for interaction with Swift.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#swauth OpentelekomcloudProvider#swauth}
     *
     * @stability stable
     */
    readonly swauth?: boolean | cdktf.IResolvable;
    /**
     * The ID of the Tenant (Identity v2) or Project (Identity v3) to login with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#tenant_id OpentelekomcloudProvider#tenant_id}
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * The name of the Tenant (Identity v2) or Project (Identity v3) to login with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#tenant_name OpentelekomcloudProvider#tenant_name}
     *
     * @stability stable
     */
    readonly tenantName?: string;
    /**
     * Authentication token to use as an alternative to username/password.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#token OpentelekomcloudProvider#token}
     *
     * @stability stable
     */
    readonly token?: string;
    /**
     * User ID to login with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#user_id OpentelekomcloudProvider#user_id}
     *
     * @stability stable
     */
    readonly userId?: string;
    /**
     * Username to login with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#user_name OpentelekomcloudProvider#user_name}
     *
     * @stability stable
     */
    readonly userName?: string;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud#alias OpentelekomcloudProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud opentelekomcloud}.
 *
 * @stability stable
 */
export declare class OpentelekomcloudProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud opentelekomcloud} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: OpentelekomcloudProviderConfig);
    private _accessKey?;
    /**
     * @stability stable
     */
    get accessKey(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set accessKey(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetAccessKey(): void;
    /**
     * @stability stable
     */
    get accessKeyInput(): string | undefined;
    private _agencyDomainName?;
    /**
     * @stability stable
     */
    get agencyDomainName(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set agencyDomainName(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetAgencyDomainName(): void;
    /**
     * @stability stable
     */
    get agencyDomainNameInput(): string | undefined;
    private _agencyName?;
    /**
     * @stability stable
     */
    get agencyName(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set agencyName(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetAgencyName(): void;
    /**
     * @stability stable
     */
    get agencyNameInput(): string | undefined;
    private _authUrl?;
    /**
     * @stability stable
     */
    get authUrl(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set authUrl(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetAuthUrl(): void;
    /**
     * @stability stable
     */
    get authUrlInput(): string | undefined;
    private _cacertFile?;
    /**
     * @stability stable
     */
    get cacertFile(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set cacertFile(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetCacertFile(): void;
    /**
     * @stability stable
     */
    get cacertFileInput(): string | undefined;
    private _cert?;
    /**
     * @stability stable
     */
    get cert(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set cert(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetCert(): void;
    /**
     * @stability stable
     */
    get certInput(): string | undefined;
    private _cloud?;
    /**
     * @stability stable
     */
    get cloud(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set cloud(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetCloud(): void;
    /**
     * @stability stable
     */
    get cloudInput(): string | undefined;
    private _delegatedProject?;
    /**
     * @stability stable
     */
    get delegatedProject(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set delegatedProject(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetDelegatedProject(): void;
    /**
     * @stability stable
     */
    get delegatedProjectInput(): string | undefined;
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set domainId(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetDomainId(): void;
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set domainName(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetDomainName(): void;
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _endpointType?;
    /**
     * @stability stable
     */
    get endpointType(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set endpointType(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetEndpointType(): void;
    /**
     * @stability stable
     */
    get endpointTypeInput(): string | undefined;
    private _insecure?;
    /**
     * @stability stable
     */
    get insecure(): boolean | cdktf.IResolvable | undefined | undefined;
    /**
     * @stability stable
     */
    set insecure(value: boolean | cdktf.IResolvable | undefined | undefined);
    /**
     * @stability stable
     */
    resetInsecure(): void;
    /**
     * @stability stable
     */
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set key(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetKey(): void;
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _maxRetries?;
    /**
     * @stability stable
     */
    get maxRetries(): number | undefined | undefined;
    /**
     * @stability stable
     */
    set maxRetries(value: number | undefined | undefined);
    /**
     * @stability stable
     */
    resetMaxRetries(): void;
    /**
     * @stability stable
     */
    get maxRetriesInput(): number | undefined;
    private _passcode?;
    /**
     * @stability stable
     */
    get passcode(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set passcode(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetPasscode(): void;
    /**
     * @stability stable
     */
    get passcodeInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set password(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _secretKey?;
    /**
     * @stability stable
     */
    get secretKey(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set secretKey(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetSecretKey(): void;
    /**
     * @stability stable
     */
    get secretKeyInput(): string | undefined;
    private _securityToken?;
    /**
     * @stability stable
     */
    get securityToken(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set securityToken(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetSecurityToken(): void;
    /**
     * @stability stable
     */
    get securityTokenInput(): string | undefined;
    private _swauth?;
    /**
     * @stability stable
     */
    get swauth(): boolean | cdktf.IResolvable | undefined | undefined;
    /**
     * @stability stable
     */
    set swauth(value: boolean | cdktf.IResolvable | undefined | undefined);
    /**
     * @stability stable
     */
    resetSwauth(): void;
    /**
     * @stability stable
     */
    get swauthInput(): boolean | cdktf.IResolvable | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _tenantName?;
    /**
     * @stability stable
     */
    get tenantName(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set tenantName(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetTenantName(): void;
    /**
     * @stability stable
     */
    get tenantNameInput(): string | undefined;
    private _token?;
    /**
     * @stability stable
     */
    get token(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set token(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetToken(): void;
    /**
     * @stability stable
     */
    get tokenInput(): string | undefined;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set userId(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetUserId(): void;
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    private _userName?;
    /**
     * @stability stable
     */
    get userName(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set userName(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetUserName(): void;
    /**
     * @stability stable
     */
    get userNameInput(): string | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
