import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RdsInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#availabilityzone RdsInstanceV1#availabilityzone}.
     *
     * @stability stable
     */
    readonly availabilityzone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#dbport RdsInstanceV1#dbport}.
     *
     * @stability stable
     */
    readonly dbport?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#dbrtpd RdsInstanceV1#dbrtpd}.
     *
     * @stability stable
     */
    readonly dbrtpd: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#flavorref RdsInstanceV1#flavorref}.
     *
     * @stability stable
     */
    readonly flavorref: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#name RdsInstanceV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#region RdsInstanceV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#tag RdsInstanceV1#tag}.
     *
     * @stability stable
     */
    readonly tag?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#vpc RdsInstanceV1#vpc}.
     *
     * @stability stable
     */
    readonly vpc: string;
    /**
     * backupstrategy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#backupstrategy RdsInstanceV1#backupstrategy}
     *
     * @stability stable
     */
    readonly backupstrategy?: RdsInstanceV1Backupstrategy;
    /**
     * datastore block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#datastore RdsInstanceV1#datastore}
     *
     * @stability stable
     */
    readonly datastore: RdsInstanceV1Datastore;
    /**
     * ha block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#ha RdsInstanceV1#ha}
     *
     * @stability stable
     */
    readonly ha?: RdsInstanceV1Ha;
    /**
     * nics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#nics RdsInstanceV1#nics}
     *
     * @stability stable
     */
    readonly nics: RdsInstanceV1Nics;
    /**
     * securitygroup block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#securitygroup RdsInstanceV1#securitygroup}
     *
     * @stability stable
     */
    readonly securitygroup: RdsInstanceV1Securitygroup;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#timeouts RdsInstanceV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RdsInstanceV1Timeouts;
    /**
     * volume block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#volume RdsInstanceV1#volume}
     *
     * @stability stable
     */
    readonly volume: RdsInstanceV1Volume;
}
/**
 * @stability stable
 */
export interface RdsInstanceV1Backupstrategy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#keepdays RdsInstanceV1#keepdays}.
     *
     * @stability stable
     */
    readonly keepdays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#starttime RdsInstanceV1#starttime}.
     *
     * @stability stable
     */
    readonly starttime?: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV1BackupstrategyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _keepdays?;
    /**
     * @stability stable
     */
    get keepdays(): number | undefined;
    /**
     * @stability stable
     */
    set keepdays(value: number | undefined);
    /**
     * @stability stable
     */
    resetKeepdays(): void;
    /**
     * @stability stable
     */
    get keepdaysInput(): number | undefined;
    private _starttime?;
    /**
     * @stability stable
     */
    get starttime(): string | undefined;
    /**
     * @stability stable
     */
    set starttime(value: string | undefined);
    /**
     * @stability stable
     */
    resetStarttime(): void;
    /**
     * @stability stable
     */
    get starttimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV1Datastore {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#type RdsInstanceV1#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#version RdsInstanceV1#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV1DatastoreOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV1Ha {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#enable RdsInstanceV1#enable}.
     *
     * @stability stable
     */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#replicationmode RdsInstanceV1#replicationmode}.
     *
     * @stability stable
     */
    readonly replicationmode?: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV1HaOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnable(): void;
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _replicationmode?;
    /**
     * @stability stable
     */
    get replicationmode(): string | undefined;
    /**
     * @stability stable
     */
    set replicationmode(value: string | undefined);
    /**
     * @stability stable
     */
    resetReplicationmode(): void;
    /**
     * @stability stable
     */
    get replicationmodeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV1Nics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#subnetid RdsInstanceV1#subnetid}.
     *
     * @stability stable
     */
    readonly subnetid: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV1NicsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _subnetid?;
    /**
     * @stability stable
     */
    get subnetid(): string;
    /**
     * @stability stable
     */
    set subnetid(value: string);
    /**
     * @stability stable
     */
    get subnetidInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV1Securitygroup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#id RdsInstanceV1#id}.
     *
     * @stability stable
     */
    readonly id: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV1SecuritygroupOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#create RdsInstanceV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#delete RdsInstanceV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV1Volume {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#size RdsInstanceV1#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html#type RdsInstanceV1#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV1VolumeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html opentelekomcloud_rds_instance_v1}.
 *
 * @stability stable
 */
export declare class RdsInstanceV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v1.html opentelekomcloud_rds_instance_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RdsInstanceV1Config);
    private _availabilityzone?;
    /**
     * @stability stable
     */
    get availabilityzone(): string;
    /**
     * @stability stable
     */
    set availabilityzone(value: string);
    /**
     * @stability stable
     */
    get availabilityzoneInput(): string | undefined;
    /**
     * @stability stable
     */
    get created(): string;
    private _dbport?;
    /**
     * @stability stable
     */
    get dbport(): string | undefined;
    /**
     * @stability stable
     */
    set dbport(value: string | undefined);
    /**
     * @stability stable
     */
    resetDbport(): void;
    /**
     * @stability stable
     */
    get dbportInput(): string | undefined;
    private _dbrtpd?;
    /**
     * @stability stable
     */
    get dbrtpd(): string;
    /**
     * @stability stable
     */
    set dbrtpd(value: string);
    /**
     * @stability stable
     */
    get dbrtpdInput(): string | undefined;
    private _flavorref?;
    /**
     * @stability stable
     */
    get flavorref(): string;
    /**
     * @stability stable
     */
    set flavorref(value: string);
    /**
     * @stability stable
     */
    get flavorrefInput(): string | undefined;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tag(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get updated(): string;
    private _vpc?;
    /**
     * @stability stable
     */
    get vpc(): string;
    /**
     * @stability stable
     */
    set vpc(value: string);
    /**
     * @stability stable
     */
    get vpcInput(): string | undefined;
    private _backupstrategy?;
    private __backupstrategyOutput;
    /**
     * @stability stable
     */
    get backupstrategy(): RdsInstanceV1BackupstrategyOutputReference;
    /**
     * @stability stable
     */
    putBackupstrategy(value: RdsInstanceV1Backupstrategy | undefined): void;
    /**
     * @stability stable
     */
    resetBackupstrategy(): void;
    /**
     * @stability stable
     */
    get backupstrategyInput(): RdsInstanceV1Backupstrategy | undefined;
    private _datastore?;
    private __datastoreOutput;
    /**
     * @stability stable
     */
    get datastore(): RdsInstanceV1DatastoreOutputReference;
    /**
     * @stability stable
     */
    putDatastore(value: RdsInstanceV1Datastore): void;
    /**
     * @stability stable
     */
    get datastoreInput(): RdsInstanceV1Datastore | undefined;
    private _ha?;
    private __haOutput;
    /**
     * @stability stable
     */
    get ha(): RdsInstanceV1HaOutputReference;
    /**
     * @stability stable
     */
    putHa(value: RdsInstanceV1Ha | undefined): void;
    /**
     * @stability stable
     */
    resetHa(): void;
    /**
     * @stability stable
     */
    get haInput(): RdsInstanceV1Ha | undefined;
    private _nics?;
    private __nicsOutput;
    /**
     * @stability stable
     */
    get nics(): RdsInstanceV1NicsOutputReference;
    /**
     * @stability stable
     */
    putNics(value: RdsInstanceV1Nics): void;
    /**
     * @stability stable
     */
    get nicsInput(): RdsInstanceV1Nics | undefined;
    private _securitygroup?;
    private __securitygroupOutput;
    /**
     * @stability stable
     */
    get securitygroup(): RdsInstanceV1SecuritygroupOutputReference;
    /**
     * @stability stable
     */
    putSecuritygroup(value: RdsInstanceV1Securitygroup): void;
    /**
     * @stability stable
     */
    get securitygroupInput(): RdsInstanceV1Securitygroup | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): RdsInstanceV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RdsInstanceV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RdsInstanceV1Timeouts | undefined;
    private _volume?;
    private __volumeOutput;
    /**
     * @stability stable
     */
    get volume(): RdsInstanceV1VolumeOutputReference;
    /**
     * @stability stable
     */
    putVolume(value: RdsInstanceV1Volume): void;
    /**
     * @stability stable
     */
    get volumeInput(): RdsInstanceV1Volume | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
