import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RdsInstanceV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#availability_zone RdsInstanceV3#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#flavor RdsInstanceV3#flavor}.
     *
     * @stability stable
     */
    readonly flavor: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#ha_replication_mode RdsInstanceV3#ha_replication_mode}.
     *
     * @stability stable
     */
    readonly haReplicationMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#name RdsInstanceV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#param_group_id RdsInstanceV3#param_group_id}.
     *
     * @stability stable
     */
    readonly paramGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#parameters RdsInstanceV3#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#public_ips RdsInstanceV3#public_ips}.
     *
     * @stability stable
     */
    readonly publicIps?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#security_group_id RdsInstanceV3#security_group_id}.
     *
     * @stability stable
     */
    readonly securityGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#subnet_id RdsInstanceV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#tag RdsInstanceV3#tag}.
     *
     * @stability stable
     */
    readonly tag?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#tags RdsInstanceV3#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#vpc_id RdsInstanceV3#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * backup_strategy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#backup_strategy RdsInstanceV3#backup_strategy}
     *
     * @stability stable
     */
    readonly backupStrategy?: RdsInstanceV3BackupStrategy;
    /**
     * db block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#db RdsInstanceV3#db}
     *
     * @stability stable
     */
    readonly db: RdsInstanceV3Db;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#timeouts RdsInstanceV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RdsInstanceV3Timeouts;
    /**
     * volume block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#volume RdsInstanceV3#volume}
     *
     * @stability stable
     */
    readonly volume: RdsInstanceV3Volume;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV3Nodes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    get status(): string;
}
/**
 * @stability stable
 */
export interface RdsInstanceV3BackupStrategy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#keep_days RdsInstanceV3#keep_days}.
     *
     * @stability stable
     */
    readonly keepDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#start_time RdsInstanceV3#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV3BackupStrategyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _keepDays?;
    /**
     * @stability stable
     */
    get keepDays(): number | undefined;
    /**
     * @stability stable
     */
    set keepDays(value: number | undefined);
    /**
     * @stability stable
     */
    resetKeepDays(): void;
    /**
     * @stability stable
     */
    get keepDaysInput(): number | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV3Db {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#password RdsInstanceV3#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#port RdsInstanceV3#port}.
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#type RdsInstanceV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#version RdsInstanceV3#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV3DbOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#create RdsInstanceV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#update RdsInstanceV3#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsInstanceV3Volume {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#disk_encryption_id RdsInstanceV3#disk_encryption_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#size RdsInstanceV3#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html#type RdsInstanceV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export declare class RdsInstanceV3VolumeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskEncryptionId?;
    /**
     * @stability stable
     */
    get diskEncryptionId(): string | undefined;
    /**
     * @stability stable
     */
    set diskEncryptionId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDiskEncryptionId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionIdInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html opentelekomcloud_rds_instance_v3}.
 *
 * @stability stable
 */
export declare class RdsInstanceV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_instance_v3.html opentelekomcloud_rds_instance_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RdsInstanceV3Config);
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string[];
    /**
     * @stability stable
     */
    set availabilityZone(value: string[]);
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get created(): string;
    private _flavor?;
    /**
     * @stability stable
     */
    get flavor(): string;
    /**
     * @stability stable
     */
    set flavor(value: string);
    /**
     * @stability stable
     */
    get flavorInput(): string | undefined;
    private _haReplicationMode?;
    /**
     * @stability stable
     */
    get haReplicationMode(): string | undefined;
    /**
     * @stability stable
     */
    set haReplicationMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetHaReplicationMode(): void;
    /**
     * @stability stable
     */
    get haReplicationModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    nodes(index: string): RdsInstanceV3Nodes;
    private _paramGroupId?;
    /**
     * @stability stable
     */
    get paramGroupId(): string | undefined;
    /**
     * @stability stable
     */
    set paramGroupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetParamGroupId(): void;
    /**
     * @stability stable
     */
    get paramGroupIdInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get privateIps(): string[];
    private _publicIps?;
    /**
     * @stability stable
     */
    get publicIps(): string[] | undefined;
    /**
     * @stability stable
     */
    set publicIps(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetPublicIps(): void;
    /**
     * @stability stable
     */
    get publicIpsInput(): string[] | undefined;
    private _securityGroupId?;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    set securityGroupId(value: string);
    /**
     * @stability stable
     */
    get securityGroupIdInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tag(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _backupStrategy?;
    private __backupStrategyOutput;
    /**
     * @stability stable
     */
    get backupStrategy(): RdsInstanceV3BackupStrategyOutputReference;
    /**
     * @stability stable
     */
    putBackupStrategy(value: RdsInstanceV3BackupStrategy | undefined): void;
    /**
     * @stability stable
     */
    resetBackupStrategy(): void;
    /**
     * @stability stable
     */
    get backupStrategyInput(): RdsInstanceV3BackupStrategy | undefined;
    private _db?;
    private __dbOutput;
    /**
     * @stability stable
     */
    get db(): RdsInstanceV3DbOutputReference;
    /**
     * @stability stable
     */
    putDb(value: RdsInstanceV3Db): void;
    /**
     * @stability stable
     */
    get dbInput(): RdsInstanceV3Db | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): RdsInstanceV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RdsInstanceV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RdsInstanceV3Timeouts | undefined;
    private _volume?;
    private __volumeOutput;
    /**
     * @stability stable
     */
    get volume(): RdsInstanceV3VolumeOutputReference;
    /**
     * @stability stable
     */
    putVolume(value: RdsInstanceV3Volume): void;
    /**
     * @stability stable
     */
    get volumeInput(): RdsInstanceV3Volume | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
