import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RdsParametergroupV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3.html#description RdsParametergroupV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3.html#name RdsParametergroupV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3.html#values RdsParametergroupV3#values}.
     *
     * @stability stable
     */
    readonly values?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * datastore block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3.html#datastore RdsParametergroupV3#datastore}
     *
     * @stability stable
     */
    readonly datastore: RdsParametergroupV3Datastore;
}
/**
 * @stability stable
 */
export declare class RdsParametergroupV3ConfigurationParameters extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get readonly(): any;
    /**
     * @stability stable
     */
    get restartRequired(): any;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    get valueRange(): string;
}
/**
 * @stability stable
 */
export interface RdsParametergroupV3Datastore {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3.html#type RdsParametergroupV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3.html#version RdsParametergroupV3#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
/**
 * @stability stable
 */
export declare class RdsParametergroupV3DatastoreOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3.html opentelekomcloud_rds_parametergroup_v3}.
 *
 * @stability stable
 */
export declare class RdsParametergroupV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_parametergroup_v3.html opentelekomcloud_rds_parametergroup_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RdsParametergroupV3Config);
    /**
     * @stability stable
     */
    configurationParameters(index: string): RdsParametergroupV3ConfigurationParameters;
    /**
     * @stability stable
     */
    get created(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get updated(): string;
    private _values?;
    /**
     * @stability stable
     */
    get values(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set values(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _datastore?;
    private __datastoreOutput;
    /**
     * @stability stable
     */
    get datastore(): RdsParametergroupV3DatastoreOutputReference;
    /**
     * @stability stable
     */
    putDatastore(value: RdsParametergroupV3Datastore): void;
    /**
     * @stability stable
     */
    get datastoreInput(): RdsParametergroupV3Datastore | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
