import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RdsReadReplicaV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#availability_zone RdsReadReplicaV3#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#flavor_ref RdsReadReplicaV3#flavor_ref}.
     *
     * @stability stable
     */
    readonly flavorRef: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#name RdsReadReplicaV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#public_ips RdsReadReplicaV3#public_ips}.
     *
     * @stability stable
     */
    readonly publicIps?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#region RdsReadReplicaV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#replica_of_id RdsReadReplicaV3#replica_of_id}.
     *
     * @stability stable
     */
    readonly replicaOfId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#timeouts RdsReadReplicaV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RdsReadReplicaV3Timeouts;
    /**
     * volume block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#volume RdsReadReplicaV3#volume}
     *
     * @stability stable
     */
    readonly volume: RdsReadReplicaV3Volume;
}
/**
 * @stability stable
 */
export declare class RdsReadReplicaV3Db extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get userName(): string;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export interface RdsReadReplicaV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#create RdsReadReplicaV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#update RdsReadReplicaV3#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class RdsReadReplicaV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface RdsReadReplicaV3Volume {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#disk_encryption_id RdsReadReplicaV3#disk_encryption_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html#type RdsReadReplicaV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export declare class RdsReadReplicaV3VolumeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskEncryptionId?;
    /**
     * @stability stable
     */
    get diskEncryptionId(): string | undefined;
    /**
     * @stability stable
     */
    set diskEncryptionId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDiskEncryptionId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionIdInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html opentelekomcloud_rds_read_replica_v3}.
 *
 * @stability stable
 */
export declare class RdsReadReplicaV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rds_read_replica_v3.html opentelekomcloud_rds_read_replica_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RdsReadReplicaV3Config);
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityZone(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    /**
     * @stability stable
     */
    db(index: string): RdsReadReplicaV3Db;
    private _flavorRef?;
    /**
     * @stability stable
     */
    get flavorRef(): string;
    /**
     * @stability stable
     */
    set flavorRef(value: string);
    /**
     * @stability stable
     */
    get flavorRefInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIps(): string[];
    private _publicIps?;
    /**
     * @stability stable
     */
    get publicIps(): string[] | undefined;
    /**
     * @stability stable
     */
    set publicIps(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetPublicIps(): void;
    /**
     * @stability stable
     */
    get publicIpsInput(): string[] | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _replicaOfId?;
    /**
     * @stability stable
     */
    get replicaOfId(): string;
    /**
     * @stability stable
     */
    set replicaOfId(value: string);
    /**
     * @stability stable
     */
    get replicaOfIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    get vpcId(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): RdsReadReplicaV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RdsReadReplicaV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RdsReadReplicaV3Timeouts | undefined;
    private _volume?;
    private __volumeOutput;
    /**
     * @stability stable
     */
    get volume(): RdsReadReplicaV3VolumeOutputReference;
    /**
     * @stability stable
     */
    putVolume(value: RdsReadReplicaV3Volume): void;
    /**
     * @stability stable
     */
    get volumeInput(): RdsReadReplicaV3Volume | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
