import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RtsSoftwareConfigV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#config RtsSoftwareConfigV1#config}.
     *
     * @stability stable
     */
    readonly config?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#group RtsSoftwareConfigV1#group}.
     *
     * @stability stable
     */
    readonly group?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#input_values RtsSoftwareConfigV1#input_values}.
     *
     * @stability stable
     */
    readonly inputValues?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#name RtsSoftwareConfigV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#options RtsSoftwareConfigV1#options}.
     *
     * @stability stable
     */
    readonly options?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#output_values RtsSoftwareConfigV1#output_values}.
     *
     * @stability stable
     */
    readonly outputValues?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#region RtsSoftwareConfigV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#timeouts RtsSoftwareConfigV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RtsSoftwareConfigV1Timeouts;
}
/**
 * @stability stable
 */
export interface RtsSoftwareConfigV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#create RtsSoftwareConfigV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html#delete RtsSoftwareConfigV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class RtsSoftwareConfigV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html opentelekomcloud_rts_software_config_v1}.
 *
 * @stability stable
 */
export declare class RtsSoftwareConfigV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_software_config_v1.html opentelekomcloud_rts_software_config_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RtsSoftwareConfigV1Config);
    private _config?;
    /**
     * @stability stable
     */
    get config(): string | undefined;
    /**
     * @stability stable
     */
    set config(value: string | undefined);
    /**
     * @stability stable
     */
    resetConfig(): void;
    /**
     * @stability stable
     */
    get configInput(): string | undefined;
    private _group?;
    /**
     * @stability stable
     */
    get group(): string | undefined;
    /**
     * @stability stable
     */
    set group(value: string | undefined);
    /**
     * @stability stable
     */
    resetGroup(): void;
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _inputValues?;
    /**
     * @stability stable
     */
    get inputValues(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set inputValues(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInputValues(): void;
    /**
     * @stability stable
     */
    get inputValuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _options?;
    /**
     * @stability stable
     */
    get options(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set options(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetOptions(): void;
    /**
     * @stability stable
     */
    get optionsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _outputValues?;
    /**
     * @stability stable
     */
    get outputValues(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set outputValues(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetOutputValues(): void;
    /**
     * @stability stable
     */
    get outputValuesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): RtsSoftwareConfigV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RtsSoftwareConfigV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RtsSoftwareConfigV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
