import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RtsStackV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#disable_rollback RtsStackV1#disable_rollback}.
     *
     * @stability stable
     */
    readonly disableRollback?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#environment RtsStackV1#environment}.
     *
     * @stability stable
     */
    readonly environment?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#files RtsStackV1#files}.
     *
     * @stability stable
     */
    readonly files?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#name RtsStackV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#parameters RtsStackV1#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#region RtsStackV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#template_body RtsStackV1#template_body}.
     *
     * @stability stable
     */
    readonly templateBody?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#template_url RtsStackV1#template_url}.
     *
     * @stability stable
     */
    readonly templateUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#timeout_mins RtsStackV1#timeout_mins}.
     *
     * @stability stable
     */
    readonly timeoutMins?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#timeouts RtsStackV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RtsStackV1Timeouts;
}
/**
 * @stability stable
 */
export interface RtsStackV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#create RtsStackV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#delete RtsStackV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html#update RtsStackV1#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class RtsStackV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html opentelekomcloud_rts_stack_v1}.
 *
 * @stability stable
 */
export declare class RtsStackV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/rts_stack_v1.html opentelekomcloud_rts_stack_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RtsStackV1Config);
    /**
     * @stability stable
     */
    get capabilities(): string[];
    private _disableRollback?;
    /**
     * @stability stable
     */
    get disableRollback(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disableRollback(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisableRollback(): void;
    /**
     * @stability stable
     */
    get disableRollbackInput(): boolean | cdktf.IResolvable | undefined;
    private _environment?;
    /**
     * @stability stable
     */
    get environment(): string | undefined;
    /**
     * @stability stable
     */
    set environment(value: string | undefined);
    /**
     * @stability stable
     */
    resetEnvironment(): void;
    /**
     * @stability stable
     */
    get environmentInput(): string | undefined;
    private _files?;
    /**
     * @stability stable
     */
    get files(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set files(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetFiles(): void;
    /**
     * @stability stable
     */
    get filesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get notificationTopics(): string[];
    /**
     * @stability stable
     */
    outputs(key: string): string;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get statusReason(): string;
    private _templateBody?;
    /**
     * @stability stable
     */
    get templateBody(): string | undefined;
    /**
     * @stability stable
     */
    set templateBody(value: string | undefined);
    /**
     * @stability stable
     */
    resetTemplateBody(): void;
    /**
     * @stability stable
     */
    get templateBodyInput(): string | undefined;
    private _templateUrl?;
    /**
     * @stability stable
     */
    get templateUrl(): string | undefined;
    /**
     * @stability stable
     */
    set templateUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetTemplateUrl(): void;
    /**
     * @stability stable
     */
    get templateUrlInput(): string | undefined;
    private _timeoutMins?;
    /**
     * @stability stable
     */
    get timeoutMins(): number | undefined;
    /**
     * @stability stable
     */
    set timeoutMins(value: number | undefined);
    /**
     * @stability stable
     */
    resetTimeoutMins(): void;
    /**
     * @stability stable
     */
    get timeoutMinsInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): RtsStackV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RtsStackV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RtsStackV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
