import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface S3BucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#acl S3BucketObject#acl}.
     *
     * @stability stable
     */
    readonly acl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#bucket S3BucketObject#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#cache_control S3BucketObject#cache_control}.
     *
     * @stability stable
     */
    readonly cacheControl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#content S3BucketObject#content}.
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#content_disposition S3BucketObject#content_disposition}.
     *
     * @stability stable
     */
    readonly contentDisposition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#content_encoding S3BucketObject#content_encoding}.
     *
     * @stability stable
     */
    readonly contentEncoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#content_language S3BucketObject#content_language}.
     *
     * @stability stable
     */
    readonly contentLanguage?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#content_type S3BucketObject#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#etag S3BucketObject#etag}.
     *
     * @stability stable
     */
    readonly etag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#key S3BucketObject#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#server_side_encryption S3BucketObject#server_side_encryption}.
     *
     * @stability stable
     */
    readonly serverSideEncryption?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#source S3BucketObject#source}.
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#sse_kms_key_id S3BucketObject#sse_kms_key_id}.
     *
     * @stability stable
     */
    readonly sseKmsKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html#website_redirect S3BucketObject#website_redirect}.
     *
     * @stability stable
     */
    readonly websiteRedirect?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html opentelekomcloud_s3_bucket_object}.
 *
 * @stability stable
 */
export declare class S3BucketObject extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_object.html opentelekomcloud_s3_bucket_object} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: S3BucketObjectConfig);
    private _acl?;
    /**
     * @stability stable
     */
    get acl(): string | undefined;
    /**
     * @stability stable
     */
    set acl(value: string | undefined);
    /**
     * @stability stable
     */
    resetAcl(): void;
    /**
     * @stability stable
     */
    get aclInput(): string | undefined;
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _cacheControl?;
    /**
     * @stability stable
     */
    get cacheControl(): string | undefined;
    /**
     * @stability stable
     */
    set cacheControl(value: string | undefined);
    /**
     * @stability stable
     */
    resetCacheControl(): void;
    /**
     * @stability stable
     */
    get cacheControlInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string | undefined;
    /**
     * @stability stable
     */
    set content(value: string | undefined);
    /**
     * @stability stable
     */
    resetContent(): void;
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _contentDisposition?;
    /**
     * @stability stable
     */
    get contentDisposition(): string | undefined;
    /**
     * @stability stable
     */
    set contentDisposition(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentDisposition(): void;
    /**
     * @stability stable
     */
    get contentDispositionInput(): string | undefined;
    private _contentEncoding?;
    /**
     * @stability stable
     */
    get contentEncoding(): string | undefined;
    /**
     * @stability stable
     */
    set contentEncoding(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentEncoding(): void;
    /**
     * @stability stable
     */
    get contentEncodingInput(): string | undefined;
    private _contentLanguage?;
    /**
     * @stability stable
     */
    get contentLanguage(): string | undefined;
    /**
     * @stability stable
     */
    set contentLanguage(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentLanguage(): void;
    /**
     * @stability stable
     */
    get contentLanguageInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string | undefined;
    /**
     * @stability stable
     */
    set contentType(value: string | undefined);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _etag?;
    /**
     * @stability stable
     */
    get etag(): string | undefined;
    /**
     * @stability stable
     */
    set etag(value: string | undefined);
    /**
     * @stability stable
     */
    resetEtag(): void;
    /**
     * @stability stable
     */
    get etagInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _serverSideEncryption?;
    /**
     * @stability stable
     */
    get serverSideEncryption(): string | undefined;
    /**
     * @stability stable
     */
    set serverSideEncryption(value: string | undefined);
    /**
     * @stability stable
     */
    resetServerSideEncryption(): void;
    /**
     * @stability stable
     */
    get serverSideEncryptionInput(): string | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string | undefined;
    /**
     * @stability stable
     */
    set source(value: string | undefined);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _sseKmsKeyId?;
    /**
     * @stability stable
     */
    get sseKmsKeyId(): string | undefined;
    /**
     * @stability stable
     */
    set sseKmsKeyId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSseKmsKeyId(): void;
    /**
     * @stability stable
     */
    get sseKmsKeyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get versionId(): string;
    private _websiteRedirect?;
    /**
     * @stability stable
     */
    get websiteRedirect(): string | undefined;
    /**
     * @stability stable
     */
    set websiteRedirect(value: string | undefined);
    /**
     * @stability stable
     */
    resetWebsiteRedirect(): void;
    /**
     * @stability stable
     */
    get websiteRedirectInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
