import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface S3BucketPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_policy.html#bucket S3BucketPolicy#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_policy.html#policy S3BucketPolicy#policy}.
     *
     * @stability stable
     */
    readonly policy: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_policy.html opentelekomcloud_s3_bucket_policy}.
 *
 * @stability stable
 */
export declare class S3BucketPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket_policy.html opentelekomcloud_s3_bucket_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: S3BucketPolicyConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _policy?;
    /**
     * @stability stable
     */
    get policy(): string;
    /**
     * @stability stable
     */
    set policy(value: string);
    /**
     * @stability stable
     */
    get policyInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
