import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface S3BucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#acl S3Bucket#acl}.
     *
     * @stability stable
     */
    readonly acl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#bucket S3Bucket#bucket}.
     *
     * @stability stable
     */
    readonly bucket?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#bucket_prefix S3Bucket#bucket_prefix}.
     *
     * @stability stable
     */
    readonly bucketPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#force_destroy S3Bucket#force_destroy}.
     *
     * @stability stable
     */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#hosted_zone_id S3Bucket#hosted_zone_id}.
     *
     * @stability stable
     */
    readonly hostedZoneId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#policy S3Bucket#policy}.
     *
     * @stability stable
     */
    readonly policy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#region S3Bucket#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#tags S3Bucket#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#website_domain S3Bucket#website_domain}.
     *
     * @stability stable
     */
    readonly websiteDomain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#website_endpoint S3Bucket#website_endpoint}.
     *
     * @stability stable
     */
    readonly websiteEndpoint?: string;
    /**
     * cors_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#cors_rule S3Bucket#cors_rule}
     *
     * @stability stable
     */
    readonly corsRule?: S3BucketCorsRule[];
    /**
     * lifecycle_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#lifecycle_rule S3Bucket#lifecycle_rule}
     *
     * @stability stable
     */
    readonly lifecycleRule?: S3BucketLifecycleRule[];
    /**
     * logging block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#logging S3Bucket#logging}
     *
     * @stability stable
     */
    readonly logging?: S3BucketLogging[];
    /**
     * versioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#versioning S3Bucket#versioning}
     *
     * @stability stable
     */
    readonly versioning?: S3BucketVersioning;
    /**
     * website block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#website S3Bucket#website}
     *
     * @stability stable
     */
    readonly website?: S3BucketWebsite;
}
/**
 * @stability stable
 */
export interface S3BucketCorsRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#allowed_headers S3Bucket#allowed_headers}.
     *
     * @stability stable
     */
    readonly allowedHeaders?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#allowed_methods S3Bucket#allowed_methods}.
     *
     * @stability stable
     */
    readonly allowedMethods: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#allowed_origins S3Bucket#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#expose_headers S3Bucket#expose_headers}.
     *
     * @stability stable
     */
    readonly exposeHeaders?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#max_age_seconds S3Bucket#max_age_seconds}.
     *
     * @stability stable
     */
    readonly maxAgeSeconds?: number;
}
/**
 * @stability stable
 */
export interface S3BucketLifecycleRuleExpiration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#date S3Bucket#date}.
     *
     * @stability stable
     */
    readonly date?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#days S3Bucket#days}.
     *
     * @stability stable
     */
    readonly days?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#expired_object_delete_marker S3Bucket#expired_object_delete_marker}.
     *
     * @stability stable
     */
    readonly expiredObjectDeleteMarker?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface S3BucketLifecycleRuleNoncurrentVersionExpiration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#days S3Bucket#days}.
     *
     * @stability stable
     */
    readonly days?: number;
}
/**
 * @stability stable
 */
export interface S3BucketLifecycleRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#abort_incomplete_multipart_upload_days S3Bucket#abort_incomplete_multipart_upload_days}.
     *
     * @stability stable
     */
    readonly abortIncompleteMultipartUploadDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#enabled S3Bucket#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#id S3Bucket#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#prefix S3Bucket#prefix}.
     *
     * @stability stable
     */
    readonly prefix?: string;
    /**
     * expiration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#expiration S3Bucket#expiration}
     *
     * @stability stable
     */
    readonly expiration?: S3BucketLifecycleRuleExpiration[];
    /**
     * noncurrent_version_expiration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#noncurrent_version_expiration S3Bucket#noncurrent_version_expiration}
     *
     * @stability stable
     */
    readonly noncurrentVersionExpiration?: S3BucketLifecycleRuleNoncurrentVersionExpiration[];
}
/**
 * @stability stable
 */
export interface S3BucketLogging {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#target_bucket S3Bucket#target_bucket}.
     *
     * @stability stable
     */
    readonly targetBucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#target_prefix S3Bucket#target_prefix}.
     *
     * @stability stable
     */
    readonly targetPrefix?: string;
}
/**
 * @stability stable
 */
export interface S3BucketVersioning {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#enabled S3Bucket#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#mfa_delete S3Bucket#mfa_delete}.
     *
     * @stability stable
     */
    readonly mfaDelete?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class S3BucketVersioningOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mfaDelete?;
    /**
     * @stability stable
     */
    get mfaDelete(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set mfaDelete(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMfaDelete(): void;
    /**
     * @stability stable
     */
    get mfaDeleteInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface S3BucketWebsite {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#error_document S3Bucket#error_document}.
     *
     * @stability stable
     */
    readonly errorDocument?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#index_document S3Bucket#index_document}.
     *
     * @stability stable
     */
    readonly indexDocument?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#redirect_all_requests_to S3Bucket#redirect_all_requests_to}.
     *
     * @stability stable
     */
    readonly redirectAllRequestsTo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html#routing_rules S3Bucket#routing_rules}.
     *
     * @stability stable
     */
    readonly routingRules?: string;
}
/**
 * @stability stable
 */
export declare class S3BucketWebsiteOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _errorDocument?;
    /**
     * @stability stable
     */
    get errorDocument(): string | undefined;
    /**
     * @stability stable
     */
    set errorDocument(value: string | undefined);
    /**
     * @stability stable
     */
    resetErrorDocument(): void;
    /**
     * @stability stable
     */
    get errorDocumentInput(): string | undefined;
    private _indexDocument?;
    /**
     * @stability stable
     */
    get indexDocument(): string | undefined;
    /**
     * @stability stable
     */
    set indexDocument(value: string | undefined);
    /**
     * @stability stable
     */
    resetIndexDocument(): void;
    /**
     * @stability stable
     */
    get indexDocumentInput(): string | undefined;
    private _redirectAllRequestsTo?;
    /**
     * @stability stable
     */
    get redirectAllRequestsTo(): string | undefined;
    /**
     * @stability stable
     */
    set redirectAllRequestsTo(value: string | undefined);
    /**
     * @stability stable
     */
    resetRedirectAllRequestsTo(): void;
    /**
     * @stability stable
     */
    get redirectAllRequestsToInput(): string | undefined;
    private _routingRules?;
    /**
     * @stability stable
     */
    get routingRules(): string | undefined;
    /**
     * @stability stable
     */
    set routingRules(value: string | undefined);
    /**
     * @stability stable
     */
    resetRoutingRules(): void;
    /**
     * @stability stable
     */
    get routingRulesInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html opentelekomcloud_s3_bucket}.
 *
 * @stability stable
 */
export declare class S3Bucket extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/s3_bucket.html opentelekomcloud_s3_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: S3BucketConfig);
    private _acl?;
    /**
     * @stability stable
     */
    get acl(): string | undefined;
    /**
     * @stability stable
     */
    set acl(value: string | undefined);
    /**
     * @stability stable
     */
    resetAcl(): void;
    /**
     * @stability stable
     */
    get aclInput(): string | undefined;
    /**
     * @stability stable
     */
    get arn(): string;
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string | undefined;
    /**
     * @stability stable
     */
    set bucket(value: string | undefined);
    /**
     * @stability stable
     */
    resetBucket(): void;
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get bucketDomainName(): string;
    private _bucketPrefix?;
    /**
     * @stability stable
     */
    get bucketPrefix(): string | undefined;
    /**
     * @stability stable
     */
    set bucketPrefix(value: string | undefined);
    /**
     * @stability stable
     */
    resetBucketPrefix(): void;
    /**
     * @stability stable
     */
    get bucketPrefixInput(): string | undefined;
    private _forceDestroy?;
    /**
     * @stability stable
     */
    get forceDestroy(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forceDestroy(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForceDestroy(): void;
    /**
     * @stability stable
     */
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _hostedZoneId?;
    /**
     * @stability stable
     */
    get hostedZoneId(): string | undefined;
    /**
     * @stability stable
     */
    set hostedZoneId(value: string | undefined);
    /**
     * @stability stable
     */
    resetHostedZoneId(): void;
    /**
     * @stability stable
     */
    get hostedZoneIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _policy?;
    /**
     * @stability stable
     */
    get policy(): string | undefined;
    /**
     * @stability stable
     */
    set policy(value: string | undefined);
    /**
     * @stability stable
     */
    resetPolicy(): void;
    /**
     * @stability stable
     */
    get policyInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _websiteDomain?;
    /**
     * @stability stable
     */
    get websiteDomain(): string | undefined;
    /**
     * @stability stable
     */
    set websiteDomain(value: string | undefined);
    /**
     * @stability stable
     */
    resetWebsiteDomain(): void;
    /**
     * @stability stable
     */
    get websiteDomainInput(): string | undefined;
    private _websiteEndpoint?;
    /**
     * @stability stable
     */
    get websiteEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set websiteEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetWebsiteEndpoint(): void;
    /**
     * @stability stable
     */
    get websiteEndpointInput(): string | undefined;
    private _corsRule?;
    /**
     * @stability stable
     */
    get corsRule(): S3BucketCorsRule[] | undefined;
    /**
     * @stability stable
     */
    set corsRule(value: S3BucketCorsRule[] | undefined);
    /**
     * @stability stable
     */
    resetCorsRule(): void;
    /**
     * @stability stable
     */
    get corsRuleInput(): S3BucketCorsRule[] | undefined;
    private _lifecycleRule?;
    /**
     * @stability stable
     */
    get lifecycleRule(): S3BucketLifecycleRule[] | undefined;
    /**
     * @stability stable
     */
    set lifecycleRule(value: S3BucketLifecycleRule[] | undefined);
    /**
     * @stability stable
     */
    resetLifecycleRule(): void;
    /**
     * @stability stable
     */
    get lifecycleRuleInput(): S3BucketLifecycleRule[] | undefined;
    private _logging?;
    /**
     * @stability stable
     */
    get logging(): S3BucketLogging[] | undefined;
    /**
     * @stability stable
     */
    set logging(value: S3BucketLogging[] | undefined);
    /**
     * @stability stable
     */
    resetLogging(): void;
    /**
     * @stability stable
     */
    get loggingInput(): S3BucketLogging[] | undefined;
    private _versioning?;
    private __versioningOutput;
    /**
     * @stability stable
     */
    get versioning(): S3BucketVersioningOutputReference;
    /**
     * @stability stable
     */
    putVersioning(value: S3BucketVersioning | undefined): void;
    /**
     * @stability stable
     */
    resetVersioning(): void;
    /**
     * @stability stable
     */
    get versioningInput(): S3BucketVersioning | undefined;
    private _website?;
    private __websiteOutput;
    /**
     * @stability stable
     */
    get website(): S3BucketWebsiteOutputReference;
    /**
     * @stability stable
     */
    putWebsite(value: S3BucketWebsite | undefined): void;
    /**
     * @stability stable
     */
    resetWebsite(): void;
    /**
     * @stability stable
     */
    get websiteInput(): S3BucketWebsite | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
