import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SdrsProtectiongroupV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#description SdrsProtectiongroupV1#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#domain_id SdrsProtectiongroupV1#domain_id}.
     *
     * @stability stable
     */
    readonly domainId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#dr_type SdrsProtectiongroupV1#dr_type}.
     *
     * @stability stable
     */
    readonly drType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#name SdrsProtectiongroupV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#source_availability_zone SdrsProtectiongroupV1#source_availability_zone}.
     *
     * @stability stable
     */
    readonly sourceAvailabilityZone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#source_vpc_id SdrsProtectiongroupV1#source_vpc_id}.
     *
     * @stability stable
     */
    readonly sourceVpcId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#target_availability_zone SdrsProtectiongroupV1#target_availability_zone}.
     *
     * @stability stable
     */
    readonly targetAvailabilityZone: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#timeouts SdrsProtectiongroupV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SdrsProtectiongroupV1Timeouts;
}
/**
 * @stability stable
 */
export interface SdrsProtectiongroupV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#create SdrsProtectiongroupV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html#delete SdrsProtectiongroupV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class SdrsProtectiongroupV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html opentelekomcloud_sdrs_protectiongroup_v1}.
 *
 * @stability stable
 */
export declare class SdrsProtectiongroupV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sdrs_protectiongroup_v1.html opentelekomcloud_sdrs_protectiongroup_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SdrsProtectiongroupV1Config);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string;
    /**
     * @stability stable
     */
    set domainId(value: string);
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    private _drType?;
    /**
     * @stability stable
     */
    get drType(): string | undefined;
    /**
     * @stability stable
     */
    set drType(value: string | undefined);
    /**
     * @stability stable
     */
    resetDrType(): void;
    /**
     * @stability stable
     */
    get drTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sourceAvailabilityZone?;
    /**
     * @stability stable
     */
    get sourceAvailabilityZone(): string;
    /**
     * @stability stable
     */
    set sourceAvailabilityZone(value: string);
    /**
     * @stability stable
     */
    get sourceAvailabilityZoneInput(): string | undefined;
    private _sourceVpcId?;
    /**
     * @stability stable
     */
    get sourceVpcId(): string;
    /**
     * @stability stable
     */
    set sourceVpcId(value: string);
    /**
     * @stability stable
     */
    get sourceVpcIdInput(): string | undefined;
    private _targetAvailabilityZone?;
    /**
     * @stability stable
     */
    get targetAvailabilityZone(): string;
    /**
     * @stability stable
     */
    set targetAvailabilityZone(value: string);
    /**
     * @stability stable
     */
    get targetAvailabilityZoneInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): SdrsProtectiongroupV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SdrsProtectiongroupV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SdrsProtectiongroupV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
