import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SfsFileSystemV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#access_level SfsFileSystemV2#access_level}.
     *
     * @stability stable
     */
    readonly accessLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#access_to SfsFileSystemV2#access_to}.
     *
     * @stability stable
     */
    readonly accessTo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#access_type SfsFileSystemV2#access_type}.
     *
     * @stability stable
     */
    readonly accessType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#availability_zone SfsFileSystemV2#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#description SfsFileSystemV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#is_public SfsFileSystemV2#is_public}.
     *
     * @stability stable
     */
    readonly isPublic?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#metadata SfsFileSystemV2#metadata}.
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#name SfsFileSystemV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#region SfsFileSystemV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#share_proto SfsFileSystemV2#share_proto}.
     *
     * @stability stable
     */
    readonly shareProto?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#size SfsFileSystemV2#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#tags SfsFileSystemV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#timeouts SfsFileSystemV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SfsFileSystemV2Timeouts;
}
/**
 * @stability stable
 */
export interface SfsFileSystemV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#create SfsFileSystemV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html#delete SfsFileSystemV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class SfsFileSystemV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html opentelekomcloud_sfs_file_system_v2}.
 *
 * @stability stable
 */
export declare class SfsFileSystemV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_file_system_v2.html opentelekomcloud_sfs_file_system_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SfsFileSystemV2Config);
    private _accessLevel?;
    /**
     * @stability stable
     */
    get accessLevel(): string | undefined;
    /**
     * @stability stable
     */
    set accessLevel(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessLevel(): void;
    /**
     * @stability stable
     */
    get accessLevelInput(): string | undefined;
    /**
     * @stability stable
     */
    get accessRuleStatus(): string;
    private _accessTo?;
    /**
     * @stability stable
     */
    get accessTo(): string | undefined;
    /**
     * @stability stable
     */
    set accessTo(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessTo(): void;
    /**
     * @stability stable
     */
    get accessToInput(): string | undefined;
    private _accessType?;
    /**
     * @stability stable
     */
    get accessType(): string | undefined;
    /**
     * @stability stable
     */
    set accessType(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessType(): void;
    /**
     * @stability stable
     */
    get accessTypeInput(): string | undefined;
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityZone(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get exportLocation(): string;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _isPublic?;
    /**
     * @stability stable
     */
    get isPublic(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isPublic(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsPublic(): void;
    /**
     * @stability stable
     */
    get isPublicInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get shareAccessId(): string;
    private _shareProto?;
    /**
     * @stability stable
     */
    get shareProto(): string | undefined;
    /**
     * @stability stable
     */
    set shareProto(value: string | undefined);
    /**
     * @stability stable
     */
    resetShareProto(): void;
    /**
     * @stability stable
     */
    get shareProtoInput(): string | undefined;
    /**
     * @stability stable
     */
    get shareType(): string;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get volumeType(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): SfsFileSystemV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SfsFileSystemV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SfsFileSystemV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
