import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SfsShareAccessRulesV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2.html#share_id SfsShareAccessRulesV2#share_id}.
     *
     * @stability stable
     */
    readonly shareId: string;
    /**
     * access_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2.html#access_rule SfsShareAccessRulesV2#access_rule}
     *
     * @stability stable
     */
    readonly accessRule: SfsShareAccessRulesV2AccessRule[];
}
/**
 * @stability stable
 */
export interface SfsShareAccessRulesV2AccessRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2.html#access_level SfsShareAccessRulesV2#access_level}.
     *
     * @stability stable
     */
    readonly accessLevel: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2.html#access_to SfsShareAccessRulesV2#access_to}.
     *
     * @stability stable
     */
    readonly accessTo: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2.html#access_type SfsShareAccessRulesV2#access_type}.
     *
     * @stability stable
     */
    readonly accessType?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2.html opentelekomcloud_sfs_share_access_rules_v2}.
 *
 * @stability stable
 */
export declare class SfsShareAccessRulesV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/sfs_share_access_rules_v2.html opentelekomcloud_sfs_share_access_rules_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SfsShareAccessRulesV2Config);
    /**
     * @stability stable
     */
    get id(): string;
    private _shareId?;
    /**
     * @stability stable
     */
    get shareId(): string;
    /**
     * @stability stable
     */
    set shareId(value: string);
    /**
     * @stability stable
     */
    get shareIdInput(): string | undefined;
    private _accessRule?;
    /**
     * @stability stable
     */
    get accessRule(): SfsShareAccessRulesV2AccessRule[];
    /**
     * @stability stable
     */
    set accessRule(value: SfsShareAccessRulesV2AccessRule[]);
    /**
     * @stability stable
     */
    get accessRuleInput(): SfsShareAccessRulesV2AccessRule[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
