import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SmnSubscriptionV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_subscription_v2.html#endpoint SmnSubscriptionV2#endpoint}.
     *
     * @stability stable
     */
    readonly endpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_subscription_v2.html#project_name SmnSubscriptionV2#project_name}.
     *
     * @stability stable
     */
    readonly projectName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_subscription_v2.html#protocol SmnSubscriptionV2#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_subscription_v2.html#remark SmnSubscriptionV2#remark}.
     *
     * @stability stable
     */
    readonly remark?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_subscription_v2.html#topic_urn SmnSubscriptionV2#topic_urn}.
     *
     * @stability stable
     */
    readonly topicUrn: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_subscription_v2.html opentelekomcloud_smn_subscription_v2}.
 *
 * @stability stable
 */
export declare class SmnSubscriptionV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_subscription_v2.html opentelekomcloud_smn_subscription_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SmnSubscriptionV2Config);
    private _endpoint?;
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    set endpoint(value: string);
    /**
     * @stability stable
     */
    get endpointInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get owner(): string;
    private _projectName?;
    /**
     * @stability stable
     */
    get projectName(): string | undefined;
    /**
     * @stability stable
     */
    set projectName(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectName(): void;
    /**
     * @stability stable
     */
    get projectNameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _remark?;
    /**
     * @stability stable
     */
    get remark(): string | undefined;
    /**
     * @stability stable
     */
    set remark(value: string | undefined);
    /**
     * @stability stable
     */
    resetRemark(): void;
    /**
     * @stability stable
     */
    get remarkInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): number;
    /**
     * @stability stable
     */
    get subscriptionUrn(): string;
    private _topicUrn?;
    /**
     * @stability stable
     */
    get topicUrn(): string;
    /**
     * @stability stable
     */
    set topicUrn(value: string);
    /**
     * @stability stable
     */
    get topicUrnInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
