import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SmnTopicAttributeV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2.html#attribute_name SmnTopicAttributeV2#attribute_name}.
     *
     * @stability stable
     */
    readonly attributeName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2.html#topic_attribute SmnTopicAttributeV2#topic_attribute}.
     *
     * @stability stable
     */
    readonly topicAttribute: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2.html#topic_urn SmnTopicAttributeV2#topic_urn}.
     *
     * @stability stable
     */
    readonly topicUrn: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2.html opentelekomcloud_smn_topic_attribute_v2}.
 *
 * @stability stable
 */
export declare class SmnTopicAttributeV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_attribute_v2.html opentelekomcloud_smn_topic_attribute_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SmnTopicAttributeV2Config);
    private _attributeName?;
    /**
     * @stability stable
     */
    get attributeName(): string;
    /**
     * @stability stable
     */
    set attributeName(value: string);
    /**
     * @stability stable
     */
    get attributeNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _topicAttribute?;
    /**
     * @stability stable
     */
    get topicAttribute(): string;
    /**
     * @stability stable
     */
    set topicAttribute(value: string);
    /**
     * @stability stable
     */
    get topicAttributeInput(): string | undefined;
    private _topicUrn?;
    /**
     * @stability stable
     */
    get topicUrn(): string;
    /**
     * @stability stable
     */
    set topicUrn(value: string);
    /**
     * @stability stable
     */
    get topicUrnInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
