import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SmnTopicV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2.html#display_name SmnTopicV2#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2.html#name SmnTopicV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2.html#project_name SmnTopicV2#project_name}.
     *
     * @stability stable
     */
    readonly projectName?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2.html opentelekomcloud_smn_topic_v2}.
 *
 * @stability stable
 */
export declare class SmnTopicV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/smn_topic_v2.html opentelekomcloud_smn_topic_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SmnTopicV2Config);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string | undefined;
    /**
     * @stability stable
     */
    set displayName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _projectName?;
    /**
     * @stability stable
     */
    get projectName(): string | undefined;
    /**
     * @stability stable
     */
    set projectName(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectName(): void;
    /**
     * @stability stable
     */
    get projectNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get pushPolicy(): number;
    /**
     * @stability stable
     */
    get topicUrn(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
