import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SwrDomainV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html#access_domain SwrDomainV2#access_domain}.
     *
     * @stability stable
     */
    readonly accessDomain: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html#deadline SwrDomainV2#deadline}.
     *
     * @stability stable
     */
    readonly deadline: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html#description SwrDomainV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html#organization SwrDomainV2#organization}.
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html#permission SwrDomainV2#permission}.
     *
     * @stability stable
     */
    readonly permission: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html#repository SwrDomainV2#repository}.
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html#timeouts SwrDomainV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SwrDomainV2Timeouts;
}
/**
 * @stability stable
 */
export interface SwrDomainV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html#default SwrDomainV2#default}.
     *
     * @stability stable
     */
    readonly default?: string;
}
/**
 * @stability stable
 */
export declare class SwrDomainV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    /**
     * @stability stable
     */
    get default(): string | undefined;
    /**
     * @stability stable
     */
    set default(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefault(): void;
    /**
     * @stability stable
     */
    get defaultInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html opentelekomcloud_swr_domain_v2}.
 *
 * @stability stable
 */
export declare class SwrDomainV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_domain_v2.html opentelekomcloud_swr_domain_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SwrDomainV2Config);
    private _accessDomain?;
    /**
     * @stability stable
     */
    get accessDomain(): string;
    /**
     * @stability stable
     */
    set accessDomain(value: string);
    /**
     * @stability stable
     */
    get accessDomainInput(): string | undefined;
    /**
     * @stability stable
     */
    get created(): string;
    /**
     * @stability stable
     */
    get creatorId(): string;
    /**
     * @stability stable
     */
    get creatorName(): string;
    private _deadline?;
    /**
     * @stability stable
     */
    get deadline(): string;
    /**
     * @stability stable
     */
    set deadline(value: string);
    /**
     * @stability stable
     */
    get deadlineInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    private _permission?;
    /**
     * @stability stable
     */
    get permission(): string;
    /**
     * @stability stable
     */
    set permission(value: string);
    /**
     * @stability stable
     */
    get permissionInput(): string | undefined;
    private _repository?;
    /**
     * @stability stable
     */
    get repository(): string;
    /**
     * @stability stable
     */
    set repository(value: string);
    /**
     * @stability stable
     */
    get repositoryInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): any;
    /**
     * @stability stable
     */
    get updated(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): SwrDomainV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SwrDomainV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SwrDomainV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
