import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SwrOrganizationPermissionsV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2.html#auth SwrOrganizationPermissionsV2#auth}.
     *
     * @stability stable
     */
    readonly auth: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2.html#organization SwrOrganizationPermissionsV2#organization}.
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2.html#user_id SwrOrganizationPermissionsV2#user_id}.
     *
     * @stability stable
     */
    readonly userId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2.html#username SwrOrganizationPermissionsV2#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2.html#timeouts SwrOrganizationPermissionsV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SwrOrganizationPermissionsV2Timeouts;
}
/**
 * @stability stable
 */
export interface SwrOrganizationPermissionsV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2.html#default SwrOrganizationPermissionsV2#default}.
     *
     * @stability stable
     */
    readonly default?: string;
}
/**
 * @stability stable
 */
export declare class SwrOrganizationPermissionsV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    /**
     * @stability stable
     */
    get default(): string | undefined;
    /**
     * @stability stable
     */
    set default(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefault(): void;
    /**
     * @stability stable
     */
    get defaultInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2.html opentelekomcloud_swr_organization_permissions_v2}.
 *
 * @stability stable
 */
export declare class SwrOrganizationPermissionsV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_organization_permissions_v2.html opentelekomcloud_swr_organization_permissions_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SwrOrganizationPermissionsV2Config);
    private _auth?;
    /**
     * @stability stable
     */
    get auth(): number;
    /**
     * @stability stable
     */
    set auth(value: number);
    /**
     * @stability stable
     */
    get authInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): SwrOrganizationPermissionsV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SwrOrganizationPermissionsV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SwrOrganizationPermissionsV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
