import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SwrRepositoryV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html#category SwrRepositoryV2#category}.
     *
     * @stability stable
     */
    readonly category?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html#description SwrRepositoryV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html#is_public SwrRepositoryV2#is_public}.
     *
     * @stability stable
     */
    readonly isPublic: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html#name SwrRepositoryV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html#organization SwrRepositoryV2#organization}.
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html#timeouts SwrRepositoryV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SwrRepositoryV2Timeouts;
}
/**
 * @stability stable
 */
export interface SwrRepositoryV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html#default SwrRepositoryV2#default}.
     *
     * @stability stable
     */
    readonly default?: string;
}
/**
 * @stability stable
 */
export declare class SwrRepositoryV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    /**
     * @stability stable
     */
    get default(): string | undefined;
    /**
     * @stability stable
     */
    set default(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefault(): void;
    /**
     * @stability stable
     */
    get defaultInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html opentelekomcloud_swr_repository_v2}.
 *
 * @stability stable
 */
export declare class SwrRepositoryV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/swr_repository_v2.html opentelekomcloud_swr_repository_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SwrRepositoryV2Config);
    private _category?;
    /**
     * @stability stable
     */
    get category(): string | undefined;
    /**
     * @stability stable
     */
    set category(value: string | undefined);
    /**
     * @stability stable
     */
    resetCategory(): void;
    /**
     * @stability stable
     */
    get categoryInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get internalPath(): string;
    private _isPublic?;
    /**
     * @stability stable
     */
    get isPublic(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isPublic(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isPublicInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get numImages(): number;
    private _organization?;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string | undefined;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    get repositoryId(): number;
    /**
     * @stability stable
     */
    get size(): number;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): SwrRepositoryV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SwrRepositoryV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SwrRepositoryV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
