import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VbsBackupPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#frequency VbsBackupPolicyV2#frequency}.
     *
     * @stability stable
     */
    readonly frequency?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#name VbsBackupPolicyV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#region VbsBackupPolicyV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#rentention_day VbsBackupPolicyV2#rentention_day}.
     *
     * @stability stable
     */
    readonly rententionDay?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#rentention_num VbsBackupPolicyV2#rentention_num}.
     *
     * @stability stable
     */
    readonly rententionNum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#resources VbsBackupPolicyV2#resources}.
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#retain_first_backup VbsBackupPolicyV2#retain_first_backup}.
     *
     * @stability stable
     */
    readonly retainFirstBackup: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#start_time VbsBackupPolicyV2#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#status VbsBackupPolicyV2#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#week_frequency VbsBackupPolicyV2#week_frequency}.
     *
     * @stability stable
     */
    readonly weekFrequency?: string[];
    /**
     * tags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#tags VbsBackupPolicyV2#tags}
     *
     * @stability stable
     */
    readonly tags?: VbsBackupPolicyV2Tags[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#timeouts VbsBackupPolicyV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VbsBackupPolicyV2Timeouts;
}
/**
 * @stability stable
 */
export interface VbsBackupPolicyV2Tags {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#key VbsBackupPolicyV2#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#value VbsBackupPolicyV2#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface VbsBackupPolicyV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#create VbsBackupPolicyV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html#delete VbsBackupPolicyV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class VbsBackupPolicyV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html opentelekomcloud_vbs_backup_policy_v2}.
 *
 * @stability stable
 */
export declare class VbsBackupPolicyV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_policy_v2.html opentelekomcloud_vbs_backup_policy_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VbsBackupPolicyV2Config);
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): number | undefined;
    /**
     * @stability stable
     */
    set frequency(value: number | undefined);
    /**
     * @stability stable
     */
    resetFrequency(): void;
    /**
     * @stability stable
     */
    get frequencyInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get policyResourceCount(): number;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _rententionDay?;
    /**
     * @stability stable
     */
    get rententionDay(): number | undefined;
    /**
     * @stability stable
     */
    set rententionDay(value: number | undefined);
    /**
     * @stability stable
     */
    resetRententionDay(): void;
    /**
     * @stability stable
     */
    get rententionDayInput(): number | undefined;
    private _rententionNum?;
    /**
     * @stability stable
     */
    get rententionNum(): number | undefined;
    /**
     * @stability stable
     */
    set rententionNum(value: number | undefined);
    /**
     * @stability stable
     */
    resetRententionNum(): void;
    /**
     * @stability stable
     */
    get rententionNumInput(): number | undefined;
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[] | undefined;
    /**
     * @stability stable
     */
    set resources(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _retainFirstBackup?;
    /**
     * @stability stable
     */
    get retainFirstBackup(): string;
    /**
     * @stability stable
     */
    set retainFirstBackup(value: string);
    /**
     * @stability stable
     */
    get retainFirstBackupInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _weekFrequency?;
    /**
     * @stability stable
     */
    get weekFrequency(): string[] | undefined;
    /**
     * @stability stable
     */
    set weekFrequency(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetWeekFrequency(): void;
    /**
     * @stability stable
     */
    get weekFrequencyInput(): string[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): VbsBackupPolicyV2Tags[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: VbsBackupPolicyV2Tags[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): VbsBackupPolicyV2Tags[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VbsBackupPolicyV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VbsBackupPolicyV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VbsBackupPolicyV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
