import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VbsBackupShareV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2.html#backup_id VbsBackupShareV2#backup_id}.
     *
     * @stability stable
     */
    readonly backupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2.html#region VbsBackupShareV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2.html#to_project_ids VbsBackupShareV2#to_project_ids}.
     *
     * @stability stable
     */
    readonly toProjectIds: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2.html#timeouts VbsBackupShareV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VbsBackupShareV2Timeouts;
}
/**
 * @stability stable
 */
export interface VbsBackupShareV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2.html#create VbsBackupShareV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2.html#delete VbsBackupShareV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class VbsBackupShareV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2.html opentelekomcloud_vbs_backup_share_v2}.
 *
 * @stability stable
 */
export declare class VbsBackupShareV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vbs_backup_share_v2.html opentelekomcloud_vbs_backup_share_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VbsBackupShareV2Config);
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    private _backupId?;
    /**
     * @stability stable
     */
    get backupId(): string;
    /**
     * @stability stable
     */
    set backupId(value: string);
    /**
     * @stability stable
     */
    get backupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get backupName(): string;
    /**
     * @stability stable
     */
    get backupStatus(): string;
    /**
     * @stability stable
     */
    get container(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceMetadata(): string;
    /**
     * @stability stable
     */
    get shareIds(): string[];
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    get snapshotId(): string;
    private _toProjectIds?;
    /**
     * @stability stable
     */
    get toProjectIds(): string[];
    /**
     * @stability stable
     */
    set toProjectIds(value: string[]);
    /**
     * @stability stable
     */
    get toProjectIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get volumeId(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VbsBackupShareV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VbsBackupShareV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VbsBackupShareV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
