import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpcBandwidthAssociateV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_associate_v2.html#backup_charge_mode VpcBandwidthAssociateV2#backup_charge_mode}.
     *
     * @stability stable
     */
    readonly backupChargeMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_associate_v2.html#backup_size VpcBandwidthAssociateV2#backup_size}.
     *
     * @stability stable
     */
    readonly backupSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_associate_v2.html#bandwidth VpcBandwidthAssociateV2#bandwidth}.
     *
     * @stability stable
     */
    readonly bandwidth: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_associate_v2.html#floating_ips VpcBandwidthAssociateV2#floating_ips}.
     *
     * @stability stable
     */
    readonly floatingIps: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_associate_v2.html opentelekomcloud_vpc_bandwidth_associate_v2}.
 *
 * @stability stable
 */
export declare class VpcBandwidthAssociateV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_bandwidth_associate_v2.html opentelekomcloud_vpc_bandwidth_associate_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpcBandwidthAssociateV2Config);
    private _backupChargeMode?;
    /**
     * @stability stable
     */
    get backupChargeMode(): string | undefined;
    /**
     * @stability stable
     */
    set backupChargeMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackupChargeMode(): void;
    /**
     * @stability stable
     */
    get backupChargeModeInput(): string | undefined;
    private _backupSize?;
    /**
     * @stability stable
     */
    get backupSize(): number | undefined;
    /**
     * @stability stable
     */
    set backupSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetBackupSize(): void;
    /**
     * @stability stable
     */
    get backupSizeInput(): number | undefined;
    private _bandwidth?;
    /**
     * @stability stable
     */
    get bandwidth(): string;
    /**
     * @stability stable
     */
    set bandwidth(value: string);
    /**
     * @stability stable
     */
    get bandwidthInput(): string | undefined;
    private _floatingIps?;
    /**
     * @stability stable
     */
    get floatingIps(): string[];
    /**
     * @stability stable
     */
    set floatingIps(value: string[]);
    /**
     * @stability stable
     */
    get floatingIpsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
