import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpcFlowLogV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#admin_state VpcFlowLogV1#admin_state}.
     *
     * @stability stable
     */
    readonly adminState?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#description VpcFlowLogV1#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#log_group_id VpcFlowLogV1#log_group_id}.
     *
     * @stability stable
     */
    readonly logGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#log_topic_id VpcFlowLogV1#log_topic_id}.
     *
     * @stability stable
     */
    readonly logTopicId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#name VpcFlowLogV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#resource_id VpcFlowLogV1#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#resource_type VpcFlowLogV1#resource_type}.
     *
     * @stability stable
     */
    readonly resourceType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#status VpcFlowLogV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#traffic_type VpcFlowLogV1#traffic_type}.
     *
     * @stability stable
     */
    readonly trafficType: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#timeouts VpcFlowLogV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpcFlowLogV1Timeouts;
}
/**
 * @stability stable
 */
export interface VpcFlowLogV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#create VpcFlowLogV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html#delete VpcFlowLogV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class VpcFlowLogV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html opentelekomcloud_vpc_flow_log_v1}.
 *
 * @stability stable
 */
export declare class VpcFlowLogV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_flow_log_v1.html opentelekomcloud_vpc_flow_log_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpcFlowLogV1Config);
    private _adminState?;
    /**
     * @stability stable
     */
    get adminState(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminState(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminState(): void;
    /**
     * @stability stable
     */
    get adminStateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logGroupId?;
    /**
     * @stability stable
     */
    get logGroupId(): string;
    /**
     * @stability stable
     */
    set logGroupId(value: string);
    /**
     * @stability stable
     */
    get logGroupIdInput(): string | undefined;
    private _logTopicId?;
    /**
     * @stability stable
     */
    get logTopicId(): string;
    /**
     * @stability stable
     */
    set logTopicId(value: string);
    /**
     * @stability stable
     */
    get logTopicIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    set resourceId(value: string);
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _resourceType?;
    /**
     * @stability stable
     */
    get resourceType(): string;
    /**
     * @stability stable
     */
    set resourceType(value: string);
    /**
     * @stability stable
     */
    get resourceTypeInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _trafficType?;
    /**
     * @stability stable
     */
    get trafficType(): string;
    /**
     * @stability stable
     */
    set trafficType(value: string);
    /**
     * @stability stable
     */
    get trafficTypeInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VpcFlowLogV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpcFlowLogV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpcFlowLogV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
