import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpcPeeringConnectionAccepterV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2.html#accept VpcPeeringConnectionAccepterV2#accept}.
     *
     * @stability stable
     */
    readonly accept?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2.html#region VpcPeeringConnectionAccepterV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2.html#vpc_peering_connection_id VpcPeeringConnectionAccepterV2#vpc_peering_connection_id}.
     *
     * @stability stable
     */
    readonly vpcPeeringConnectionId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2.html#timeouts VpcPeeringConnectionAccepterV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpcPeeringConnectionAccepterV2Timeouts;
}
/**
 * @stability stable
 */
export interface VpcPeeringConnectionAccepterV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2.html#create VpcPeeringConnectionAccepterV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2.html#delete VpcPeeringConnectionAccepterV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class VpcPeeringConnectionAccepterV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2.html opentelekomcloud_vpc_peering_connection_accepter_v2}.
 *
 * @stability stable
 */
export declare class VpcPeeringConnectionAccepterV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_peering_connection_accepter_v2.html opentelekomcloud_vpc_peering_connection_accepter_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpcPeeringConnectionAccepterV2Config);
    private _accept?;
    /**
     * @stability stable
     */
    get accept(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set accept(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAccept(): void;
    /**
     * @stability stable
     */
    get acceptInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get peerTenantId(): string;
    /**
     * @stability stable
     */
    get peerVpcId(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get vpcId(): string;
    private _vpcPeeringConnectionId?;
    /**
     * @stability stable
     */
    get vpcPeeringConnectionId(): string;
    /**
     * @stability stable
     */
    set vpcPeeringConnectionId(value: string);
    /**
     * @stability stable
     */
    get vpcPeeringConnectionIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VpcPeeringConnectionAccepterV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpcPeeringConnectionAccepterV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpcPeeringConnectionAccepterV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
