import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpcRouteV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#destination VpcRouteV2#destination}.
     *
     * @stability stable
     */
    readonly destination: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#nexthop VpcRouteV2#nexthop}.
     *
     * @stability stable
     */
    readonly nexthop: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#region VpcRouteV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#tenant_id VpcRouteV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#type VpcRouteV2#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#vpc_id VpcRouteV2#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#timeouts VpcRouteV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpcRouteV2Timeouts;
}
/**
 * @stability stable
 */
export interface VpcRouteV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#create VpcRouteV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html#delete VpcRouteV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class VpcRouteV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html opentelekomcloud_vpc_route_v2}.
 *
 * @stability stable
 */
export declare class VpcRouteV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_route_v2.html opentelekomcloud_vpc_route_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpcRouteV2Config);
    private _destination?;
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    set destination(value: string);
    /**
     * @stability stable
     */
    get destinationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _nexthop?;
    /**
     * @stability stable
     */
    get nexthop(): string;
    /**
     * @stability stable
     */
    set nexthop(value: string);
    /**
     * @stability stable
     */
    get nexthopInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VpcRouteV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpcRouteV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpcRouteV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
