import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpcSubnetV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#availability_zone VpcSubnetV1#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#cidr VpcSubnetV1#cidr}.
     *
     * @stability stable
     */
    readonly cidr: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#dhcp_enable VpcSubnetV1#dhcp_enable}.
     *
     * @stability stable
     */
    readonly dhcpEnable?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#dns_list VpcSubnetV1#dns_list}.
     *
     * @stability stable
     */
    readonly dnsList?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#gateway_ip VpcSubnetV1#gateway_ip}.
     *
     * @stability stable
     */
    readonly gatewayIp: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#name VpcSubnetV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#ntp_addresses VpcSubnetV1#ntp_addresses}.
     *
     * @stability stable
     */
    readonly ntpAddresses?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#primary_dns VpcSubnetV1#primary_dns}.
     *
     * @stability stable
     */
    readonly primaryDns?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#region VpcSubnetV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#secondary_dns VpcSubnetV1#secondary_dns}.
     *
     * @stability stable
     */
    readonly secondaryDns?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#tags VpcSubnetV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#vpc_id VpcSubnetV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#timeouts VpcSubnetV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpcSubnetV1Timeouts;
}
/**
 * @stability stable
 */
export interface VpcSubnetV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#create VpcSubnetV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html#delete VpcSubnetV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class VpcSubnetV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html opentelekomcloud_vpc_subnet_v1}.
 *
 * @stability stable
 */
export declare class VpcSubnetV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpc_subnet_v1.html opentelekomcloud_vpc_subnet_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpcSubnetV1Config);
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityZone(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _cidr?;
    /**
     * @stability stable
     */
    get cidr(): string;
    /**
     * @stability stable
     */
    set cidr(value: string);
    /**
     * @stability stable
     */
    get cidrInput(): string | undefined;
    private _dhcpEnable?;
    /**
     * @stability stable
     */
    get dhcpEnable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set dhcpEnable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDhcpEnable(): void;
    /**
     * @stability stable
     */
    get dhcpEnableInput(): boolean | cdktf.IResolvable | undefined;
    private _dnsList?;
    /**
     * @stability stable
     */
    get dnsList(): string[] | undefined;
    /**
     * @stability stable
     */
    set dnsList(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetDnsList(): void;
    /**
     * @stability stable
     */
    get dnsListInput(): string[] | undefined;
    private _gatewayIp?;
    /**
     * @stability stable
     */
    get gatewayIp(): string;
    /**
     * @stability stable
     */
    set gatewayIp(value: string);
    /**
     * @stability stable
     */
    get gatewayIpInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get networkId(): string;
    private _ntpAddresses?;
    /**
     * @stability stable
     */
    get ntpAddresses(): string | undefined;
    /**
     * @stability stable
     */
    set ntpAddresses(value: string | undefined);
    /**
     * @stability stable
     */
    resetNtpAddresses(): void;
    /**
     * @stability stable
     */
    get ntpAddressesInput(): string | undefined;
    private _primaryDns?;
    /**
     * @stability stable
     */
    get primaryDns(): string | undefined;
    /**
     * @stability stable
     */
    set primaryDns(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryDns(): void;
    /**
     * @stability stable
     */
    get primaryDnsInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _secondaryDns?;
    /**
     * @stability stable
     */
    get secondaryDns(): string | undefined;
    /**
     * @stability stable
     */
    set secondaryDns(value: string | undefined);
    /**
     * @stability stable
     */
    resetSecondaryDns(): void;
    /**
     * @stability stable
     */
    get secondaryDnsInput(): string | undefined;
    /**
     * @stability stable
     */
    get subnetId(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VpcSubnetV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpcSubnetV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpcSubnetV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
