import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpcepEndpointV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#enable_dns VpcepEndpointV1#enable_dns}.
     *
     * @stability stable
     */
    readonly enableDns?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#enable_whitelist VpcepEndpointV1#enable_whitelist}.
     *
     * @stability stable
     */
    readonly enableWhitelist?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#port_ip VpcepEndpointV1#port_ip}.
     *
     * @stability stable
     */
    readonly portIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#route_tables VpcepEndpointV1#route_tables}.
     *
     * @stability stable
     */
    readonly routeTables?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#service_id VpcepEndpointV1#service_id}.
     *
     * @stability stable
     */
    readonly serviceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#subnet_id VpcepEndpointV1#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#tags VpcepEndpointV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#vpc_id VpcepEndpointV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#whitelist VpcepEndpointV1#whitelist}.
     *
     * @stability stable
     */
    readonly whitelist?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#timeouts VpcepEndpointV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpcepEndpointV1Timeouts;
}
/**
 * @stability stable
 */
export interface VpcepEndpointV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html#default VpcepEndpointV1#default}.
     *
     * @stability stable
     */
    readonly default?: string;
}
/**
 * @stability stable
 */
export declare class VpcepEndpointV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    /**
     * @stability stable
     */
    get default(): string | undefined;
    /**
     * @stability stable
     */
    set default(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefault(): void;
    /**
     * @stability stable
     */
    get defaultInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html opentelekomcloud_vpcep_endpoint_v1}.
 *
 * @stability stable
 */
export declare class VpcepEndpointV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_endpoint_v1.html opentelekomcloud_vpcep_endpoint_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpcepEndpointV1Config);
    /**
     * @stability stable
     */
    get dnsNames(): string[];
    private _enableDns?;
    /**
     * @stability stable
     */
    get enableDns(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableDns(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableDns(): void;
    /**
     * @stability stable
     */
    get enableDnsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableWhitelist?;
    /**
     * @stability stable
     */
    get enableWhitelist(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableWhitelist(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableWhitelist(): void;
    /**
     * @stability stable
     */
    get enableWhitelistInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get markerId(): number;
    private _portIp?;
    /**
     * @stability stable
     */
    get portIp(): string | undefined;
    /**
     * @stability stable
     */
    set portIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortIp(): void;
    /**
     * @stability stable
     */
    get portIpInput(): string | undefined;
    /**
     * @stability stable
     */
    get projectId(): string;
    private _routeTables?;
    /**
     * @stability stable
     */
    get routeTables(): string[] | undefined;
    /**
     * @stability stable
     */
    set routeTables(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRouteTables(): void;
    /**
     * @stability stable
     */
    get routeTablesInput(): string[] | undefined;
    private _serviceId?;
    /**
     * @stability stable
     */
    get serviceId(): string;
    /**
     * @stability stable
     */
    set serviceId(value: string);
    /**
     * @stability stable
     */
    get serviceIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    get serviceType(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string | undefined;
    /**
     * @stability stable
     */
    set subnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _whitelist?;
    /**
     * @stability stable
     */
    get whitelist(): string[] | undefined;
    /**
     * @stability stable
     */
    set whitelist(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetWhitelist(): void;
    /**
     * @stability stable
     */
    get whitelistInput(): string[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VpcepEndpointV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpcepEndpointV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpcepEndpointV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
