import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpcepServiceV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#approval_enabled VpcepServiceV1#approval_enabled}.
     *
     * @stability stable
     */
    readonly approvalEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#name VpcepServiceV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#pool_id VpcepServiceV1#pool_id}.
     *
     * @stability stable
     */
    readonly poolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#port_id VpcepServiceV1#port_id}.
     *
     * @stability stable
     */
    readonly portId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#server_type VpcepServiceV1#server_type}.
     *
     * @stability stable
     */
    readonly serverType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#service_type VpcepServiceV1#service_type}.
     *
     * @stability stable
     */
    readonly serviceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#tags VpcepServiceV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#tcp_proxy VpcepServiceV1#tcp_proxy}.
     *
     * @stability stable
     */
    readonly tcpProxy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#vip_port_id VpcepServiceV1#vip_port_id}.
     *
     * @stability stable
     */
    readonly vipPortId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#vpc_id VpcepServiceV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * port block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#port VpcepServiceV1#port}
     *
     * @stability stable
     */
    readonly port: VpcepServiceV1Port[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#timeouts VpcepServiceV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpcepServiceV1Timeouts;
}
/**
 * @stability stable
 */
export interface VpcepServiceV1Port {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#client_port VpcepServiceV1#client_port}.
     *
     * @stability stable
     */
    readonly clientPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#protocol VpcepServiceV1#protocol}.
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#server_port VpcepServiceV1#server_port}.
     *
     * @stability stable
     */
    readonly serverPort: number;
}
/**
 * @stability stable
 */
export interface VpcepServiceV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html#default VpcepServiceV1#default}.
     *
     * @stability stable
     */
    readonly default?: string;
}
/**
 * @stability stable
 */
export declare class VpcepServiceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    /**
     * @stability stable
     */
    get default(): string | undefined;
    /**
     * @stability stable
     */
    set default(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefault(): void;
    /**
     * @stability stable
     */
    get defaultInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html opentelekomcloud_vpcep_service_v1}.
 *
 * @stability stable
 */
export declare class VpcepServiceV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpcep_service_v1.html opentelekomcloud_vpcep_service_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpcepServiceV1Config);
    private _approvalEnabled?;
    /**
     * @stability stable
     */
    get approvalEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set approvalEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetApprovalEnabled(): void;
    /**
     * @stability stable
     */
    get approvalEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _poolId?;
    /**
     * @stability stable
     */
    get poolId(): string | undefined;
    /**
     * @stability stable
     */
    set poolId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPoolId(): void;
    /**
     * @stability stable
     */
    get poolIdInput(): string | undefined;
    private _portId?;
    /**
     * @stability stable
     */
    get portId(): string;
    /**
     * @stability stable
     */
    set portId(value: string);
    /**
     * @stability stable
     */
    get portIdInput(): string | undefined;
    private _serverType?;
    /**
     * @stability stable
     */
    get serverType(): string;
    /**
     * @stability stable
     */
    set serverType(value: string);
    /**
     * @stability stable
     */
    get serverTypeInput(): string | undefined;
    private _serviceType?;
    /**
     * @stability stable
     */
    get serviceType(): string | undefined;
    /**
     * @stability stable
     */
    set serviceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceType(): void;
    /**
     * @stability stable
     */
    get serviceTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tcpProxy?;
    /**
     * @stability stable
     */
    get tcpProxy(): string | undefined;
    /**
     * @stability stable
     */
    set tcpProxy(value: string | undefined);
    /**
     * @stability stable
     */
    resetTcpProxy(): void;
    /**
     * @stability stable
     */
    get tcpProxyInput(): string | undefined;
    private _vipPortId?;
    /**
     * @stability stable
     */
    get vipPortId(): string | undefined;
    /**
     * @stability stable
     */
    set vipPortId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVipPortId(): void;
    /**
     * @stability stable
     */
    get vipPortIdInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): VpcepServiceV1Port[];
    /**
     * @stability stable
     */
    set port(value: VpcepServiceV1Port[]);
    /**
     * @stability stable
     */
    get portInput(): VpcepServiceV1Port[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VpcepServiceV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpcepServiceV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpcepServiceV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
