import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnaasIpsecPolicyV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#auth_algorithm VpnaasIpsecPolicyV2#auth_algorithm}.
     *
     * @stability stable
     */
    readonly authAlgorithm?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#description VpnaasIpsecPolicyV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#encapsulation_mode VpnaasIpsecPolicyV2#encapsulation_mode}.
     *
     * @stability stable
     */
    readonly encapsulationMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#encryption_algorithm VpnaasIpsecPolicyV2#encryption_algorithm}.
     *
     * @stability stable
     */
    readonly encryptionAlgorithm?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#name VpnaasIpsecPolicyV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#pfs VpnaasIpsecPolicyV2#pfs}.
     *
     * @stability stable
     */
    readonly pfs?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#region VpnaasIpsecPolicyV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#tenant_id VpnaasIpsecPolicyV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#transform_protocol VpnaasIpsecPolicyV2#transform_protocol}.
     *
     * @stability stable
     */
    readonly transformProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#value_specs VpnaasIpsecPolicyV2#value_specs}.
     *
     * @stability stable
     */
    readonly valueSpecs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * lifetime block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#lifetime VpnaasIpsecPolicyV2#lifetime}
     *
     * @stability stable
     */
    readonly lifetime?: VpnaasIpsecPolicyV2Lifetime[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#timeouts VpnaasIpsecPolicyV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnaasIpsecPolicyV2Timeouts;
}
/**
 * @stability stable
 */
export interface VpnaasIpsecPolicyV2Lifetime {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#units VpnaasIpsecPolicyV2#units}.
     *
     * @stability stable
     */
    readonly units?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#value VpnaasIpsecPolicyV2#value}.
     *
     * @stability stable
     */
    readonly value?: number;
}
/**
 * @stability stable
 */
export interface VpnaasIpsecPolicyV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html#create VpnaasIpsecPolicyV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
}
/**
 * @stability stable
 */
export declare class VpnaasIpsecPolicyV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html opentelekomcloud_vpnaas_ipsec_policy_v2}.
 *
 * @stability stable
 */
export declare class VpnaasIpsecPolicyV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_ipsec_policy_v2.html opentelekomcloud_vpnaas_ipsec_policy_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: VpnaasIpsecPolicyV2Config);
    private _authAlgorithm?;
    /**
     * @stability stable
     */
    get authAlgorithm(): string | undefined;
    /**
     * @stability stable
     */
    set authAlgorithm(value: string | undefined);
    /**
     * @stability stable
     */
    resetAuthAlgorithm(): void;
    /**
     * @stability stable
     */
    get authAlgorithmInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _encapsulationMode?;
    /**
     * @stability stable
     */
    get encapsulationMode(): string | undefined;
    /**
     * @stability stable
     */
    set encapsulationMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetEncapsulationMode(): void;
    /**
     * @stability stable
     */
    get encapsulationModeInput(): string | undefined;
    private _encryptionAlgorithm?;
    /**
     * @stability stable
     */
    get encryptionAlgorithm(): string | undefined;
    /**
     * @stability stable
     */
    set encryptionAlgorithm(value: string | undefined);
    /**
     * @stability stable
     */
    resetEncryptionAlgorithm(): void;
    /**
     * @stability stable
     */
    get encryptionAlgorithmInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _pfs?;
    /**
     * @stability stable
     */
    get pfs(): string | undefined;
    /**
     * @stability stable
     */
    set pfs(value: string | undefined);
    /**
     * @stability stable
     */
    resetPfs(): void;
    /**
     * @stability stable
     */
    get pfsInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _transformProtocol?;
    /**
     * @stability stable
     */
    get transformProtocol(): string | undefined;
    /**
     * @stability stable
     */
    set transformProtocol(value: string | undefined);
    /**
     * @stability stable
     */
    resetTransformProtocol(): void;
    /**
     * @stability stable
     */
    get transformProtocolInput(): string | undefined;
    private _valueSpecs?;
    /**
     * @stability stable
     */
    get valueSpecs(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set valueSpecs(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValueSpecs(): void;
    /**
     * @stability stable
     */
    get valueSpecsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    /**
     * @stability stable
     */
    get lifetime(): VpnaasIpsecPolicyV2Lifetime[] | undefined;
    /**
     * @stability stable
     */
    set lifetime(value: VpnaasIpsecPolicyV2Lifetime[] | undefined);
    /**
     * @stability stable
     */
    resetLifetime(): void;
    /**
     * @stability stable
     */
    get lifetimeInput(): VpnaasIpsecPolicyV2Lifetime[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VpnaasIpsecPolicyV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnaasIpsecPolicyV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnaasIpsecPolicyV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
