import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VpnaasSiteConnectionV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#admin_state_up VpnaasSiteConnectionV2#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#description VpnaasSiteConnectionV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#ikepolicy_id VpnaasSiteConnectionV2#ikepolicy_id}.
     *
     * @stability stable
     */
    readonly ikepolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#initiator VpnaasSiteConnectionV2#initiator}.
     *
     * @stability stable
     */
    readonly initiator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#ipsecpolicy_id VpnaasSiteConnectionV2#ipsecpolicy_id}.
     *
     * @stability stable
     */
    readonly ipsecpolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#local_ep_group_id VpnaasSiteConnectionV2#local_ep_group_id}.
     *
     * @stability stable
     */
    readonly localEpGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#local_id VpnaasSiteConnectionV2#local_id}.
     *
     * @stability stable
     */
    readonly localId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#mtu VpnaasSiteConnectionV2#mtu}.
     *
     * @stability stable
     */
    readonly mtu?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#name VpnaasSiteConnectionV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#peer_address VpnaasSiteConnectionV2#peer_address}.
     *
     * @stability stable
     */
    readonly peerAddress: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#peer_cidrs VpnaasSiteConnectionV2#peer_cidrs}.
     *
     * @stability stable
     */
    readonly peerCidrs?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#peer_ep_group_id VpnaasSiteConnectionV2#peer_ep_group_id}.
     *
     * @stability stable
     */
    readonly peerEpGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#peer_id VpnaasSiteConnectionV2#peer_id}.
     *
     * @stability stable
     */
    readonly peerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#psk VpnaasSiteConnectionV2#psk}.
     *
     * @stability stable
     */
    readonly psk: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#region VpnaasSiteConnectionV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#tags VpnaasSiteConnectionV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#tenant_id VpnaasSiteConnectionV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#value_specs VpnaasSiteConnectionV2#value_specs}.
     *
     * @stability stable
     */
    readonly valueSpecs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#vpnservice_id VpnaasSiteConnectionV2#vpnservice_id}.
     *
     * @stability stable
     */
    readonly vpnserviceId: string;
    /**
     * dpd block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#dpd VpnaasSiteConnectionV2#dpd}
     *
     * @stability stable
     */
    readonly dpd?: VpnaasSiteConnectionV2Dpd[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#timeouts VpnaasSiteConnectionV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VpnaasSiteConnectionV2Timeouts;
}
/**
 * @stability stable
 */
export interface VpnaasSiteConnectionV2Dpd {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#action VpnaasSiteConnectionV2#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#interval VpnaasSiteConnectionV2#interval}.
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#timeout VpnaasSiteConnectionV2#timeout}.
     *
     * @stability stable
     */
    readonly timeout?: number;
}
/**
 * @stability stable
 */
export interface VpnaasSiteConnectionV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#create VpnaasSiteConnectionV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#delete VpnaasSiteConnectionV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html#update VpnaasSiteConnectionV2#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class VpnaasSiteConnectionV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html opentelekomcloud_vpnaas_site_connection_v2}.
 *
 * @stability stable
 */
export declare class VpnaasSiteConnectionV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/vpnaas_site_connection_v2.html opentelekomcloud_vpnaas_site_connection_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VpnaasSiteConnectionV2Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ikepolicyId?;
    /**
     * @stability stable
     */
    get ikepolicyId(): string;
    /**
     * @stability stable
     */
    set ikepolicyId(value: string);
    /**
     * @stability stable
     */
    get ikepolicyIdInput(): string | undefined;
    private _initiator?;
    /**
     * @stability stable
     */
    get initiator(): string | undefined;
    /**
     * @stability stable
     */
    set initiator(value: string | undefined);
    /**
     * @stability stable
     */
    resetInitiator(): void;
    /**
     * @stability stable
     */
    get initiatorInput(): string | undefined;
    private _ipsecpolicyId?;
    /**
     * @stability stable
     */
    get ipsecpolicyId(): string;
    /**
     * @stability stable
     */
    set ipsecpolicyId(value: string);
    /**
     * @stability stable
     */
    get ipsecpolicyIdInput(): string | undefined;
    private _localEpGroupId?;
    /**
     * @stability stable
     */
    get localEpGroupId(): string | undefined;
    /**
     * @stability stable
     */
    set localEpGroupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocalEpGroupId(): void;
    /**
     * @stability stable
     */
    get localEpGroupIdInput(): string | undefined;
    private _localId?;
    /**
     * @stability stable
     */
    get localId(): string | undefined;
    /**
     * @stability stable
     */
    set localId(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocalId(): void;
    /**
     * @stability stable
     */
    get localIdInput(): string | undefined;
    private _mtu?;
    /**
     * @stability stable
     */
    get mtu(): number | undefined;
    /**
     * @stability stable
     */
    set mtu(value: number | undefined);
    /**
     * @stability stable
     */
    resetMtu(): void;
    /**
     * @stability stable
     */
    get mtuInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _peerAddress?;
    /**
     * @stability stable
     */
    get peerAddress(): string;
    /**
     * @stability stable
     */
    set peerAddress(value: string);
    /**
     * @stability stable
     */
    get peerAddressInput(): string | undefined;
    private _peerCidrs?;
    /**
     * @stability stable
     */
    get peerCidrs(): string[] | undefined;
    /**
     * @stability stable
     */
    set peerCidrs(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetPeerCidrs(): void;
    /**
     * @stability stable
     */
    get peerCidrsInput(): string[] | undefined;
    private _peerEpGroupId?;
    /**
     * @stability stable
     */
    get peerEpGroupId(): string | undefined;
    /**
     * @stability stable
     */
    set peerEpGroupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPeerEpGroupId(): void;
    /**
     * @stability stable
     */
    get peerEpGroupIdInput(): string | undefined;
    private _peerId?;
    /**
     * @stability stable
     */
    get peerId(): string;
    /**
     * @stability stable
     */
    set peerId(value: string);
    /**
     * @stability stable
     */
    get peerIdInput(): string | undefined;
    private _psk?;
    /**
     * @stability stable
     */
    get psk(): string;
    /**
     * @stability stable
     */
    set psk(value: string);
    /**
     * @stability stable
     */
    get pskInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    /**
     * @stability stable
     */
    get valueSpecs(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set valueSpecs(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValueSpecs(): void;
    /**
     * @stability stable
     */
    get valueSpecsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _vpnserviceId?;
    /**
     * @stability stable
     */
    get vpnserviceId(): string;
    /**
     * @stability stable
     */
    set vpnserviceId(value: string);
    /**
     * @stability stable
     */
    get vpnserviceIdInput(): string | undefined;
    private _dpd?;
    /**
     * @stability stable
     */
    get dpd(): VpnaasSiteConnectionV2Dpd[] | undefined;
    /**
     * @stability stable
     */
    set dpd(value: VpnaasSiteConnectionV2Dpd[] | undefined);
    /**
     * @stability stable
     */
    resetDpd(): void;
    /**
     * @stability stable
     */
    get dpdInput(): VpnaasSiteConnectionV2Dpd[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): VpnaasSiteConnectionV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VpnaasSiteConnectionV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VpnaasSiteConnectionV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
