import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WafAlarmNotificationV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1.html#enabled WafAlarmNotificationV1#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1.html#locale WafAlarmNotificationV1#locale}.
     *
     * @stability stable
     */
    readonly locale?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1.html#send_frequency WafAlarmNotificationV1#send_frequency}.
     *
     * @stability stable
     */
    readonly sendFrequency: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1.html#threat WafAlarmNotificationV1#threat}.
     *
     * @stability stable
     */
    readonly threat: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1.html#times WafAlarmNotificationV1#times}.
     *
     * @stability stable
     */
    readonly times: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1.html#topic_urn WafAlarmNotificationV1#topic_urn}.
     *
     * @stability stable
     */
    readonly topicUrn: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1.html opentelekomcloud_waf_alarm_notification_v1}.
 *
 * @stability stable
 */
export declare class WafAlarmNotificationV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_alarm_notification_v1.html opentelekomcloud_waf_alarm_notification_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WafAlarmNotificationV1Config);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _locale?;
    /**
     * @stability stable
     */
    get locale(): string | undefined;
    /**
     * @stability stable
     */
    set locale(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocale(): void;
    /**
     * @stability stable
     */
    get localeInput(): string | undefined;
    private _sendFrequency?;
    /**
     * @stability stable
     */
    get sendFrequency(): number;
    /**
     * @stability stable
     */
    set sendFrequency(value: number);
    /**
     * @stability stable
     */
    get sendFrequencyInput(): number | undefined;
    private _threat?;
    /**
     * @stability stable
     */
    get threat(): string[];
    /**
     * @stability stable
     */
    set threat(value: string[]);
    /**
     * @stability stable
     */
    get threatInput(): string[] | undefined;
    private _times?;
    /**
     * @stability stable
     */
    get times(): number;
    /**
     * @stability stable
     */
    set times(value: number);
    /**
     * @stability stable
     */
    get timesInput(): number | undefined;
    private _topicUrn?;
    /**
     * @stability stable
     */
    get topicUrn(): string;
    /**
     * @stability stable
     */
    set topicUrn(value: string);
    /**
     * @stability stable
     */
    get topicUrnInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
