import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WafCcattackprotectionRuleV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#action_category WafCcattackprotectionRuleV1#action_category}.
     *
     * @stability stable
     */
    readonly actionCategory: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#block_content WafCcattackprotectionRuleV1#block_content}.
     *
     * @stability stable
     */
    readonly blockContent?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#block_content_type WafCcattackprotectionRuleV1#block_content_type}.
     *
     * @stability stable
     */
    readonly blockContentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#limit_num WafCcattackprotectionRuleV1#limit_num}.
     *
     * @stability stable
     */
    readonly limitNum: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#limit_period WafCcattackprotectionRuleV1#limit_period}.
     *
     * @stability stable
     */
    readonly limitPeriod: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#lock_time WafCcattackprotectionRuleV1#lock_time}.
     *
     * @stability stable
     */
    readonly lockTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#policy_id WafCcattackprotectionRuleV1#policy_id}.
     *
     * @stability stable
     */
    readonly policyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#tag_category WafCcattackprotectionRuleV1#tag_category}.
     *
     * @stability stable
     */
    readonly tagCategory?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#tag_contents WafCcattackprotectionRuleV1#tag_contents}.
     *
     * @stability stable
     */
    readonly tagContents?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#tag_index WafCcattackprotectionRuleV1#tag_index}.
     *
     * @stability stable
     */
    readonly tagIndex?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#tag_type WafCcattackprotectionRuleV1#tag_type}.
     *
     * @stability stable
     */
    readonly tagType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#url WafCcattackprotectionRuleV1#url}.
     *
     * @stability stable
     */
    readonly url: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#timeouts WafCcattackprotectionRuleV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: WafCcattackprotectionRuleV1Timeouts;
}
/**
 * @stability stable
 */
export interface WafCcattackprotectionRuleV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#create WafCcattackprotectionRuleV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html#delete WafCcattackprotectionRuleV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class WafCcattackprotectionRuleV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html opentelekomcloud_waf_ccattackprotection_rule_v1}.
 *
 * @stability stable
 */
export declare class WafCcattackprotectionRuleV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/waf_ccattackprotection_rule_v1.html opentelekomcloud_waf_ccattackprotection_rule_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WafCcattackprotectionRuleV1Config);
    private _actionCategory?;
    /**
     * @stability stable
     */
    get actionCategory(): string;
    /**
     * @stability stable
     */
    set actionCategory(value: string);
    /**
     * @stability stable
     */
    get actionCategoryInput(): string | undefined;
    private _blockContent?;
    /**
     * @stability stable
     */
    get blockContent(): string | undefined;
    /**
     * @stability stable
     */
    set blockContent(value: string | undefined);
    /**
     * @stability stable
     */
    resetBlockContent(): void;
    /**
     * @stability stable
     */
    get blockContentInput(): string | undefined;
    private _blockContentType?;
    /**
     * @stability stable
     */
    get blockContentType(): string | undefined;
    /**
     * @stability stable
     */
    set blockContentType(value: string | undefined);
    /**
     * @stability stable
     */
    resetBlockContentType(): void;
    /**
     * @stability stable
     */
    get blockContentTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get default(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _limitNum?;
    /**
     * @stability stable
     */
    get limitNum(): number;
    /**
     * @stability stable
     */
    set limitNum(value: number);
    /**
     * @stability stable
     */
    get limitNumInput(): number | undefined;
    private _limitPeriod?;
    /**
     * @stability stable
     */
    get limitPeriod(): number;
    /**
     * @stability stable
     */
    set limitPeriod(value: number);
    /**
     * @stability stable
     */
    get limitPeriodInput(): number | undefined;
    private _lockTime?;
    /**
     * @stability stable
     */
    get lockTime(): number | undefined;
    /**
     * @stability stable
     */
    set lockTime(value: number | undefined);
    /**
     * @stability stable
     */
    resetLockTime(): void;
    /**
     * @stability stable
     */
    get lockTimeInput(): number | undefined;
    private _policyId?;
    /**
     * @stability stable
     */
    get policyId(): string;
    /**
     * @stability stable
     */
    set policyId(value: string);
    /**
     * @stability stable
     */
    get policyIdInput(): string | undefined;
    private _tagCategory?;
    /**
     * @stability stable
     */
    get tagCategory(): string | undefined;
    /**
     * @stability stable
     */
    set tagCategory(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagCategory(): void;
    /**
     * @stability stable
     */
    get tagCategoryInput(): string | undefined;
    private _tagContents?;
    /**
     * @stability stable
     */
    get tagContents(): string[] | undefined;
    /**
     * @stability stable
     */
    set tagContents(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTagContents(): void;
    /**
     * @stability stable
     */
    get tagContentsInput(): string[] | undefined;
    private _tagIndex?;
    /**
     * @stability stable
     */
    get tagIndex(): string | undefined;
    /**
     * @stability stable
     */
    set tagIndex(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagIndex(): void;
    /**
     * @stability stable
     */
    get tagIndexInput(): string | undefined;
    private _tagType?;
    /**
     * @stability stable
     */
    get tagType(): string;
    /**
     * @stability stable
     */
    set tagType(value: string);
    /**
     * @stability stable
     */
    get tagTypeInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): WafCcattackprotectionRuleV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: WafCcattackprotectionRuleV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): WafCcattackprotectionRuleV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
